package org.jboss.vfs;

import java.util.Locale;
import org.jboss.vfs.VirtualFile;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import java.io.IOException;
import java.lang.String;
import java.lang.Exception;
import java.lang.RuntimeException;
import java.lang.Throwable;
import java.util.Arrays;
import java.io.File;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2024-04-10T11:41:39+0200")
public class VFSMessages_$bundle implements VFSMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected VFSMessages_$bundle() {}
    public static final VFSMessages_$bundle INSTANCE = new VFSMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cantSetupTempFileProvider$str() {
        return "VFS000010: Can't set up temp file provider";
    }
    @Override
    public final RuntimeException cantSetupTempFileProvider(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cantSetupTempFileProvider$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String tempDirectoryClosed$str() {
        return "VFS000011: Temp directory closed";
    }
    @Override
    public final IOException tempDirectoryClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), tempDirectoryClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tempFileProviderClosed$str() {
        return "VFS000012: Temp file provider closed";
    }
    @Override
    public final IOException tempFileProviderClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), tempFileProviderClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotCreateDirectoryForRoot$str() {
        return "VFS000014: Could not create directory for root '%s' (prefix '%s', suffix '%s') after %d attempts";
    }
    @Override
    public final IOException couldNotCreateDirectoryForRoot(final File root, final String prefix, final String suffix, final int retries) {
        final IOException result = new IOException(String.format(getLoggingLocale(), couldNotCreateDirectoryForRoot$str(), root, prefix, suffix, retries));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotCreateDirectory$str() {
        return "VFS000015: Could not create directory for original name '%s' after %d attempts";
    }
    @Override
    public final IOException couldNotCreateDirectory(final String originalName, final int retries) {
        final IOException result = new IOException(String.format(getLoggingLocale(), couldNotCreateDirectory$str(), originalName, retries));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rootFileSystemAlreadyMounted$str() {
        return "VFS000016: Root filesystem already mounted";
    }
    @Override
    public final IOException rootFileSystemAlreadyMounted() {
        final IOException result = new IOException(String.format(getLoggingLocale(), rootFileSystemAlreadyMounted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemAlreadyMountedAtMountPoint$str() {
        return "VFS000017: Filesystem already mounted at mount point \"%s\"";
    }
    @Override
    public final IOException fileSystemAlreadyMountedAtMountPoint(final org.jboss.vfs.VirtualFile mountPoint) {
        final IOException result = new IOException(String.format(getLoggingLocale(), fileSystemAlreadyMountedAtMountPoint$str(), mountPoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String streamIsClosed$str() {
        return "VFS000018: Stream is closed";
    }
    @Override
    public final IOException streamIsClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamIsClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAFile$str() {
        return "VFS000019: Not a file: '%s'";
    }
    @Override
    public final IOException notAFile(final String path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), notAFile$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteHostAccessNotSupportedForUrls$str() {
        return "VFS000020: Remote host access not supported for URLs of type '%s'";
    }
    @Override
    public final IOException remoteHostAccessNotSupportedForUrls(final String protocol) {
        final IOException result = new IOException(String.format(getLoggingLocale(), remoteHostAccessNotSupportedForUrls$str(), protocol));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullArgument$str() {
        return "VFS000021: %s must not be null";
    }
    @Override
    public final IllegalArgumentException nullArgument(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullArgument$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullOrEmpty$str() {
        return "VFS000022: Null or empty %s";
    }
    @Override
    public final IllegalArgumentException nullOrEmpty(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullOrEmpty$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parentIsNotAncestor$str() {
        return "VFS000023: Given parent (%s) is not an ancestor of this virtual file";
    }
    @Override
    public final IllegalArgumentException parentIsNotAncestor(final org.jboss.vfs.VirtualFile parent) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parentIsNotAncestor$str(), parent));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String problemCreatingNewDirectory$str() {
        return "VFS000024: Problems creating new directory: %s";
    }
    @Override
    public final IllegalArgumentException problemCreatingNewDirectory(final org.jboss.vfs.VirtualFile targetChild) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), problemCreatingNewDirectory$str(), targetChild));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidWin32Path$str() {
        return "VFS000025: Invalid Win32 path: %s";
    }
    @Override
    public final IllegalArgumentException invalidWin32Path(final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidWin32Path$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDecode$str() {
        return "VFS000026: Cannot decode: %s [%s]";
    }
    @Override
    public final IllegalArgumentException cannotDecode(final String path, final String encoding, final Exception e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotDecode$str(), path, encoding), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidJarSignature$str() {
        return "VFS000027: Invalid jar signature %s should be %s";
    }
    @Override
    public final IOException invalidJarSignature(final String bytes, final String expectedHeader) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidJarSignature$str(), bytes, expectedHeader));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidActionsString$str() {
        return "VFS000028: Invalid actions string: %s";
    }
    @Override
    public final IllegalArgumentException invalidActionsString(final String actions) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidActionsString$str(), actions));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bufferMustBeLargerThan$str() {
        return "VFS000029: The totalBufferLength must be larger than: %s";
    }
    @Override
    public final IllegalArgumentException bufferMustBeLargerThan(final int minimumBufferLength) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), bufferMustBeLargerThan$str(), minimumBufferLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bufferDoesntHaveEnoughCapacity$str() {
        return "VFS000030: Buffer does not have enough capacity";
    }
    @Override
    public final IllegalArgumentException bufferDoesntHaveEnoughCapacity() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), bufferDoesntHaveEnoughCapacity$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String preconfiguredAttributesAreImmutable$str() {
        return "VFS000031: The preconfigured attributes are immutable";
    }
    @Override
    public final IllegalStateException preconfiguredAttributesAreImmutable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), preconfiguredAttributesAreImmutable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String onRootPath$str() {
        return "VFS000032: .. on root path";
    }
    @Override
    public final IllegalStateException onRootPath() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), onRootPath$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
