/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.adminclient.command;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.jboss.adminclient.AdminClientMain;
import org.jboss.adminclient.command.AbstractClientCommand;
import org.jboss.adminclient.command.ClientCommand;

public class HelpCommand
extends AbstractClientCommand {
    public String getName() {
        return "help";
    }

    public OptionParser getOptionParser() {
        return new OptionParser();
    }

    public boolean execute(AdminClientMain client, OptionSet options) {
        List nonOptionArgs = options.nonOptionArguments();
        if (nonOptionArgs.size() > 1) {
            throw new IllegalArgumentException("Usage: " + this.getName() + " [command]");
        }
        if (nonOptionArgs.isEmpty()) {
            client.getPrintWriter().println("The following commands are available:\n");
            for (ClientCommand command : client.getCommands().values()) {
                if (command.isUndocumented()) continue;
                client.getPrintWriter().printf("  %-16s  %s\n", command.getName(), command.getHelp());
            }
            client.getPrintWriter().println("\nEnter 'help <command>' to display detailed help for a command.");
        } else {
            String commandName = (String)nonOptionArgs.get(0);
            ClientCommand command = client.getCommands().get(commandName);
            if (command != null) {
                client.getPrintWriter().println("Command: " + command.getName());
                String detailedHelp = command.getDetailedHelp() != null ? command.getDetailedHelp() : command.getHelp();
                client.getPrintWriter().println("\n" + detailedHelp);
                String syntax = "TODO";
                client.getPrintWriter().println("Usage: " + command.getName() + "\t" + syntax);
                try {
                    command.getOptionParser().printHelpOn((Writer)client.getPrintWriter());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                client.getPrintWriter().println("Unknown command: " + commandName);
            }
        }
        return true;
    }

    public String getHelp() {
        return "Display a list of available commands or the syntax for a specific command.";
    }

    public String getDetailedHelp() {
        return null;
    }

    public boolean isConnectionRequired() {
        return true;
    }
}

