/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.adminclient.command;

import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.jboss.adminclient.AdminClientMain;
import org.jboss.adminclient.command.AbstractClientCommand;
import org.jboss.adminclient.connection.ProfileServiceConnection;
import org.jboss.adminclient.connection.RemoteProfileServiceConnectionProvider;

public class ConnectCommand
extends AbstractClientCommand {
    public static final String COMMAND_NAME = "connect";

    public String getName() {
        return COMMAND_NAME;
    }

    public OptionParser getOptionParser() {
        return new OptionParser(){
            {
                this.acceptsAll(ConnectCommand.this.asList("H", "host")).withRequiredArg().ofType(String.class).describedAs("the JBoss AS instance's JNP host (may be a hostname or an IP address)");
                this.acceptsAll(ConnectCommand.this.asList("P", "port")).withRequiredArg().ofType(String.class).describedAs("the JBoss AS instance's the JNP port");
                this.acceptsAll(ConnectCommand.this.asList("u", "username")).withRequiredArg().ofType(String.class).describedAs("the username used to authenticate against the JBoss AS Profile Service");
                this.acceptsAll(ConnectCommand.this.asList("p", "password")).withRequiredArg().ofType(String.class).describedAs("the password used to authenticate against the JBoss AS Profile Service");
            }
        };
    }

    public boolean execute(AdminClientMain client, OptionSet options) {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new IllegalArgumentException("Usage: " + this.getName() + " ...");
        }
        String host = options.has("host") ? (String)options.valueOf("host") : "127.0.0.1";
        int port = options.has("port") ? (Integer)options.valueOf("port") : 1099;
        String username = (String)options.valueOf("username");
        String password = (String)options.valueOf("password");
        String jnpURL = "jnp://" + host + ":" + port;
        RemoteProfileServiceConnectionProvider connectionProvider = new RemoteProfileServiceConnectionProvider(jnpURL, username, password);
        ProfileServiceConnection connection = connectionProvider.connect();
        client.setConnection(connection);
        client.setHost(host);
        client.setPort(port);
        client.getPrintWriter().println("Connected.");
        return true;
    }

    public String getHelp() {
        return "Connect to the JBoss AS Profile Service.";
    }

    public String getDetailedHelp() {
        return null;
    }

    public boolean isConnectionRequired() {
        return false;
    }
}

