/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.versioned.CollectionStateManager;
import org.jboss.aspects.versioned.DistributedListUpdate;
import org.jboss.aspects.versioned.DistributedState;
import org.jboss.aspects.versioned.DistributedUpdate;
import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.OptimisticLockFailure;
import org.jboss.aspects.versioned.SynchronizationManager;
import org.jboss.aspects.versioned.VersionManager;
import org.jboss.aspects.versioned.VersionReference;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.util.id.GUID;

public class DistributedListState
extends CollectionStateManager
implements List,
DistributedState,
Externalizable {
    private static final long serialVersionUID = 8318313674571329182L;
    private static HashMap listMethodMap;
    protected static Logger log;
    protected volatile long versionId;
    protected ArrayList updates;
    protected String classname;
    protected transient List base;
    protected transient TransactionLocal txState = new TransactionLocal();
    protected transient TransactionLocal txVersion = new TransactionLocal();
    protected transient DistributedVersionManager versionManager;
    protected transient SynchronizationManager synchManager;
    protected transient TransactionManager tm;
    protected transient ClassProxy proxy;

    public DistributedListState() {
    }

    public DistributedListState(GUID guid, long timeout, ClassProxy proxy, List obj, DistributedVersionManager versionManager, SynchronizationManager synchManager) throws Exception {
        super(guid, timeout, listMethodMap);
        this.base = obj;
        this.classname = obj.getClass().getName();
        this.versionManager = versionManager;
        this.synchManager = synchManager;
        this.proxy = proxy;
        InitialContext ctx = new InitialContext();
        this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        this.updates = this.createListUpdates(this.base);
    }

    public HashMap getMethodMap() {
        return ClassProxyFactory.getMethodMap((String)this.base.getClass().getName());
    }

    public InstanceAdvised getObject() {
        return this.proxy;
    }

    protected List getCurrentState(boolean forUpdate) throws Exception {
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            if (forUpdate) {
                ++this.versionId;
            }
            return this.base;
        }
        List state = (List)this.txState.get(tx);
        if (state == null && forUpdate) {
            state = (List)this.base.getClass().newInstance();
            state.addAll(this.base);
            this.txState.set(tx, (Object)state);
            long newId = this.versionId + 1L;
            this.synchManager.registerUpdate(tx, this);
            this.txVersion.set(tx, (Object)new Long(newId));
            return state;
        }
        return this.base;
    }

    protected ArrayList createListUpdates(List state) {
        ArrayList<VersionReference> listUpdates = new ArrayList<VersionReference>(state.size());
        for (Object obj : state) {
            if (this.versionManager.isVersioned(obj)) {
                listUpdates.add(new VersionReference(VersionManager.getGUID((InstanceAdvised)obj)));
                continue;
            }
            listUpdates.add((VersionReference)obj);
        }
        return listUpdates;
    }

    public DistributedUpdate createTxUpdate(Transaction tx) {
        List state = (List)this.txState.get(tx);
        long newId = (Long)this.txVersion.get(tx);
        DistributedListUpdate update = new DistributedListUpdate(this.guid, this.createListUpdates(state), newId);
        return update;
    }

    public InstanceAdvised buildObject(SynchronizationManager manager, DistributedVersionManager versionManager) throws Exception {
        log.trace((Object)"building a List");
        this.versionManager = versionManager;
        this.synchManager = manager;
        log.trace((Object)("DistributedListState: classname: " + this.classname));
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
        this.base = (List)clazz.newInstance();
        for (Object val : this.updates) {
            VersionReference ref;
            if (val instanceof VersionReference && (val = manager.getObject((ref = (VersionReference)val).getGUID())) == null) {
                DistributedState fieldVal = manager.getState(ref.getGUID());
                val = fieldVal.buildObject(manager, versionManager);
                ref.set((InstanceAdvised)val);
            }
            this.base.add(val);
        }
        this.proxy = versionManager.addListVersioning(this.base, this);
        return this.proxy;
    }

    public void checkOptimisticLock(Transaction tx) {
        Long version = (Long)this.txVersion.get(tx);
        if (version <= this.versionId) {
            throw new OptimisticLockFailure("optimistic lock failure for list");
        }
    }

    public void mergeState(Transaction tx) throws Exception {
        List current;
        this.base = current = (List)this.txState.get(tx);
        Long version = (Long)this.txVersion.get(tx);
        this.versionId = version;
    }

    public void mergeState(DistributedUpdate update) throws Exception {
        DistributedListUpdate listUpdate = (DistributedListUpdate)update;
        this.versionId = listUpdate.versionId;
        this.base.clear();
        for (Object val : listUpdate.listUpdates) {
            if (val instanceof VersionReference) {
                VersionReference ref = (VersionReference)val;
                val = this.synchManager.getObject(ref.getGUID());
                ref.set((InstanceAdvised)val);
            }
            this.base.add(val);
        }
        this.updates = listUpdate.listUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object val) {
        this.lock.readLock().lock();
        try {
            val = this.versionManager.makeVersioned(val);
            List state = this.getCurrentState(true);
            boolean bl = state.add(val);
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object val) {
        try {
            this.lock.readLock().lock();
            try {
                val = this.versionManager.makeVersioned(val);
                List state = this.getCurrentState(true);
                state.add(index, val);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(true);
            Object[] copy = c.toArray();
            for (int i = 0; i < copy.length; ++i) {
                Object item = this.versionManager.makeVersioned(copy[i]);
                state.add(item);
            }
            boolean bl = true;
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(true);
            Object[] copy = c.toArray();
            for (int i = 0; i < copy.length; ++i) {
                Object item = this.versionManager.makeVersioned(copy[i]);
                state.add(index + i, item);
            }
            boolean bl = true;
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.lock.readLock().lock();
            try {
                List state = this.getCurrentState(true);
                state.clear();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            boolean bl = state.contains(o);
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            boolean bl = state.containsAll(c);
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            boolean bl = ((Object)state).equals(o);
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int i) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            Object e = state.get(i);
            this.lock.readLock().unlock();
            return e;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            int n = ((Object)state).hashCode();
            this.lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            int n = state.indexOf(o);
            this.lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            boolean bl = state.isEmpty();
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            Iterator iterator = state.iterator();
            this.lock.readLock().unlock();
            return iterator;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            int n = state.lastIndexOf(o);
            this.lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator() {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            ListIterator listIterator = state.listIterator();
            this.lock.readLock().unlock();
            return listIterator;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int index) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            ListIterator listIterator = state.listIterator(index);
            this.lock.readLock().unlock();
            return listIterator;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(true);
            Object e = state.remove(index);
            this.lock.readLock().unlock();
            return e;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(true);
            boolean bl = state.remove(o);
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(true);
            boolean bl = state.removeAll(c);
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(true);
            boolean bl = state.retainAll(c);
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        this.lock.readLock().lock();
        try {
            try {
                element = this.versionManager.makeVersioned(element);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            List state = this.getCurrentState(true);
            Object object = state.set(index, element);
            this.lock.readLock().unlock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            int n = state.size();
            this.lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subList(int fromIndex, int toIndex) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            List list = state.subList(fromIndex, toIndex);
            this.lock.readLock().unlock();
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            Object[] objectArray = state.toArray();
            this.lock.readLock().unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        this.lock.readLock().lock();
        try {
            List state = this.getCurrentState(false);
            Object[] objectArray = state.toArray(a);
            this.lock.readLock().unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().unlock();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.versionId);
        out.writeObject(this.updates);
        out.writeObject(this.classname);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.versionId = in.readLong();
        this.updates = (ArrayList)in.readObject();
        this.classname = (String)in.readObject();
        try {
            InitialContext ctx = new InitialContext();
            this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.txState = new TransactionLocal();
        this.txVersion = new TransactionLocal();
        this.methodMap = listMethodMap;
    }

    static {
        log = Logger.getLogger(DistributedListState.class);
        try {
            listMethodMap = new HashMap();
            Method[] methods = List.class.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                long hash = MethodHashing.methodHash((Method)methods[i]);
                listMethodMap.put(new Long(hash), methods[i]);
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }
}

