/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.plugins.StatefulSessionInstanceCache;

public class StatefulHASessionInstanceCache
extends StatefulSessionInstanceCache {
    public void invalidateLocally(Object id) {
        if (id == null) {
            return;
        }
        try {
            this.getCache().remove(id);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseContext get(Object id) throws RemoteException, NoSuchObjectException {
        if (id == null) {
            throw new IllegalArgumentException("Can't get an object with a null key");
        }
        EnterpriseContext ctx = null;
        Object object = this.getCacheLock();
        synchronized (object) {
            ctx = (EnterpriseContext)this.getCache().get(id);
            if (ctx != null) {
                return ctx;
            }
        }
        try {
            ctx = this.acquireContext();
            this.setKey(id, ctx);
            this.activate(ctx);
            this.logActivation(id);
            this.insert(ctx);
        }
        catch (Exception x) {
            if (ctx != null) {
                this.freeContext(ctx);
            }
            log.debug((Object)("Activation failure, id=" + id), (Throwable)x);
            throw new NoSuchObjectException(x.getMessage());
        }
        if (ctx == null) {
            throw new NoSuchObjectException("Can't find bean with id = " + id);
        }
        return ctx;
    }
}

