/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.AsynchEventHandler;
import org.jboss.ha.framework.server.DistributedReplicantManagerImplMBean;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedReplicantManagerImpl
implements DistributedReplicantManagerImplMBean,
HAPartition.HAMembershipExtendedListener,
HAPartition.HAPartitionStateTransfer,
AsynchEventHandler.AsynchEventProcessor {
    protected static final String SERVICE_NAME = "DistributedReplicantManager";
    protected static int threadID;
    protected Map localReplicants = new ConcurrentReaderHashMap();
    protected Map replicants = new ConcurrentReaderHashMap();
    protected Map keyListeners = new ConcurrentReaderHashMap();
    protected Map intraviewIdCache = new HashMap();
    protected HAPartition partition;
    protected AsynchEventHandler asynchHandler;
    protected Logger log;
    protected String nodeName = null;
    protected Latch partitionNameKnown = new Latch();
    protected boolean trace;
    protected Class[] add_types = new Class[]{String.class, String.class, Serializable.class};
    protected Class[] remove_types = new Class[]{String.class, String.class};

    public DistributedReplicantManagerImpl() {
        this.log = Logger.getLogger(this.getClass());
        this.asynchHandler = new AsynchEventHandler(this, "AsynchKeyChangeHandler");
    }

    public void createService() throws Exception {
        if (this.partition == null) {
            throw new IllegalStateException("HAPartition property must be set before creating DistributedReplicantManager service");
        }
        this.log.debug((Object)"registerRPCHandler");
        this.partition.registerRPCHandler(SERVICE_NAME, (Object)this);
        this.log.debug((Object)"subscribeToStateTransferEvents");
        this.partition.subscribeToStateTransferEvents(SERVICE_NAME, (HAPartition.HAPartitionStateTransfer)this);
        this.log.debug((Object)"registerMembershipListener");
        this.partition.registerMembershipListener((HAPartition.HAMembershipListener)this);
    }

    public void startService() throws Exception {
        this.nodeName = this.partition.getNodeName();
        this.asynchHandler.start();
        this.partitionNameKnown.release();
    }

    public void stopService() throws Exception {
        try {
            this.asynchHandler.stop();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to stop asynchHandler", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyService() throws Exception {
        if (this.localReplicants != null) {
            Map map = this.localReplicants;
            synchronized (map) {
                String[] keys = new String[this.localReplicants.size()];
                this.localReplicants.keySet().toArray(keys);
                for (int n = 0; n < keys.length; ++n) {
                    this.removeLocal(keys[n]);
                }
            }
        }
        if (this.partition != null) {
            this.partition.unregisterRPCHandler(SERVICE_NAME, (Object)this);
            this.partition.unsubscribeFromStateTransferEvents(SERVICE_NAME, (HAPartition.HAPartitionStateTransfer)this);
            this.partition.unregisterMembershipListener((HAPartition.HAMembershipListener)this);
        }
    }

    public void registerWithJmx(MBeanServer server) throws Exception {
        server.registerMBean(this, this.getObjectName());
    }

    public void unregisterWithJmx(MBeanServer server) throws Exception {
        server.unregisterMBean(this.getObjectName());
    }

    private ObjectName getObjectName() throws Exception {
        return new ObjectName("jboss:service=DistributedReplicantManager,partition=" + this.partition.getPartitionName());
    }

    @Override
    public HAPartition getHAPartition() {
        return this.partition;
    }

    public void setHAPartition(HAPartition clusterPartition) {
        this.partition = clusterPartition;
    }

    @Override
    public String listContent() throws Exception {
        Collection services = this.getAllServices();
        StringBuffer result = new StringBuffer();
        Iterator catsIter = services.iterator();
        result.append("<pre>");
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            HashMap content = (HashMap)this.replicants.get(category);
            if (content == null) {
                content = new HashMap();
            }
            Iterator keysIter = content.keySet().iterator();
            result.append("-----------------------------------------------\n");
            result.append("Service : ").append(category).append("\n\n");
            Serializable local = this.lookupLocalReplicant(category);
            if (local == null) {
                result.append("\t- Service is *not* available locally\n");
            } else {
                result.append("\t- Service *is* also available locally\n");
            }
            while (keysIter.hasNext()) {
                String location = (String)keysIter.next();
                result.append("\t- ").append(location).append("\n");
            }
            result.append("\n");
        }
        result.append("</pre>");
        return result.toString();
    }

    @Override
    public String listXmlContent() throws Exception {
        Collection services = this.getAllServices();
        StringBuffer result = new StringBuffer();
        result.append("<ReplicantManager>\n");
        for (String category : services) {
            HashMap content = (HashMap)this.replicants.get(category);
            if (content == null) {
                content = new HashMap();
            }
            Iterator keysIter = content.keySet().iterator();
            result.append("\t<Service>\n");
            result.append("\t\t<ServiceName>").append(category).append("</ServiceName>\n");
            Serializable local = this.lookupLocalReplicant(category);
            if (local != null) {
                result.append("\t\t<Location>\n");
                result.append("\t\t\t<Name local=\"True\">").append(this.nodeName).append("</Name>\n");
                result.append("\t\t</Location>\n");
            }
            while (keysIter.hasNext()) {
                String location = (String)keysIter.next();
                result.append("\t\t<Location>\n");
                result.append("\t\t\t<Name local=\"False\">").append(location).append("</Name>\n");
                result.append("\t\t</Location>\n");
            }
            result.append("\t<Service>\n");
        }
        result.append("<ReplicantManager>\n");
        return result.toString();
    }

    public Serializable getCurrentState() {
        Collection services = this.getAllServices();
        HashMap result = new HashMap();
        for (String category : services) {
            HashMap<String, Serializable> content = (HashMap<String, Serializable>)this.replicants.get(category);
            if (content == null) {
                content = new HashMap<String, Serializable>();
            } else {
                HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
                temp.putAll(content);
                content = temp;
            }
            Serializable local = this.lookupLocalReplicant(category);
            if (local != null) {
                content.put(this.nodeName, local);
            }
            result.put(category, content);
        }
        Object[] globalResult = new Object[]{result, this.intraviewIdCache};
        return globalResult;
    }

    public void setCurrentState(Serializable newState) {
        Object[] globalState = (Object[])newState;
        Map map = (Map)globalState[0];
        this.replicants.putAll(map);
        this.intraviewIdCache = (Map)globalState[1];
        if (this.trace) {
            this.log.trace((Object)(this.nodeName + ": received new state, will republish local replicants"));
        }
        MembersPublisher publisher = new MembersPublisher();
        publisher.start();
    }

    public Collection getAllServices() {
        HashSet services = new HashSet();
        services.addAll(this.localReplicants.keySet());
        services.addAll(this.replicants.keySet());
        return services;
    }

    public void membershipChangedDuringMerge(Vector deadMembers, Vector newMembers, Vector allMembers, Vector originatingGroups) {
        this.log.info((Object)"Merging partitions...");
        this.log.info((Object)("Dead members: " + deadMembers.size()));
        this.log.info((Object)("Originating groups: " + originatingGroups));
        this.purgeDeadMembers(deadMembers, true);
        if (newMembers.size() > 0) {
            new MergeMembers().start();
        }
    }

    public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
        this.log.info((Object)("I am (" + this.nodeName + ") received membershipChanged event:"));
        this.log.info((Object)("Dead members: " + deadMembers.size() + " (" + deadMembers + ")"));
        this.log.info((Object)("New Members : " + newMembers.size() + " (" + newMembers + ")"));
        this.log.info((Object)("All Members : " + allMembers.size() + " (" + allMembers + ")"));
        this.purgeDeadMembers(deadMembers, false);
    }

    @Override
    public void processEvent(Object event) {
        KeyChangeEvent kce = (KeyChangeEvent)event;
        this.notifyKeyListeners(kce.key, kce.replicants, kce.merge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, Serializable replicant) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("add, key=" + key + ", value=" + replicant));
        }
        this.partitionNameKnown.acquire();
        Object[] args = new Object[]{key, this.nodeName, replicant};
        this.partition.callMethodOnCluster(SERVICE_NAME, "_add", args, this.add_types, true);
        Map map = this.localReplicants;
        synchronized (map) {
            this.localReplicants.put(key, replicant);
            this.notifyKeyListeners(key, this.lookupReplicants(key), false);
        }
    }

    public void remove(String key) throws Exception {
        this.partitionNameKnown.acquire();
        if (this.localReplicants.containsKey(key)) {
            Object[] args = new Object[]{key, this.nodeName};
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_remove", args, this.remove_types, true);
            this.removeLocal(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLocal(String key) {
        Map map = this.localReplicants;
        synchronized (map) {
            this.localReplicants.remove(key);
            ArrayList result = this.lookupReplicants(key);
            if (result == null) {
                result = new ArrayList();
            }
            this.notifyKeyListeners(key, result, false);
        }
    }

    public Serializable lookupLocalReplicant(String key) {
        return (Serializable)this.localReplicants.get(key);
    }

    public List lookupReplicants(String key) {
        Serializable local = this.lookupLocalReplicant(key);
        Map replicant = (Map)this.replicants.get(key);
        if (replicant == null && local == null) {
            return null;
        }
        ArrayList<Serializable> rtn = new ArrayList<Serializable>();
        if (replicant == null) {
            if (local != null) {
                rtn.add(local);
            }
        } else {
            ClusterNode[] nodes = this.partition.getClusterNodes();
            for (int i = 0; i < nodes.length; ++i) {
                String replNode = nodes[i].getName();
                if (local != null && this.nodeName.equals(replNode)) {
                    rtn.add(local);
                    continue;
                }
                Object replVal = replicant.get(replNode);
                if (replVal == null) continue;
                rtn.add((Serializable)replVal);
            }
        }
        return rtn;
    }

    public List lookupReplicantsNodeNames(String key) {
        List<ClusterNode> nodes = this.lookupReplicantsNodes(key);
        if (nodes == null) {
            return null;
        }
        ArrayList<String> nodeNames = new ArrayList<String>(nodes.size());
        for (ClusterNode node : nodes) {
            nodeNames.add(node.getName());
        }
        return nodeNames;
    }

    public List<ClusterNode> lookupReplicantsNodes(String key) {
        boolean locallyReplicated = this.localReplicants.containsKey(key);
        Map replicant = (Map)this.replicants.get(key);
        if (replicant == null && !locallyReplicated) {
            return null;
        }
        ArrayList<ClusterNode> rtn = new ArrayList<ClusterNode>();
        if (replicant == null) {
            if (locallyReplicated) {
                rtn.add(this.partition.getClusterNode());
            }
        } else {
            Set keys = replicant.keySet();
            ClusterNode[] nodes = this.partition.getClusterNodes();
            for (int i = 0; i < nodes.length; ++i) {
                String keyOwner = nodes[i].getName();
                if (locallyReplicated && this.nodeName.equals(keyOwner)) {
                    rtn.add(this.partition.getClusterNode());
                    continue;
                }
                if (!keys.contains(keyOwner)) continue;
                rtn.add(nodes[i]);
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(String key, DistributedReplicantManager.ReplicantListener subscriber) {
        Map map = this.keyListeners;
        synchronized (map) {
            ArrayList<DistributedReplicantManager.ReplicantListener> listeners = (ArrayList<DistributedReplicantManager.ReplicantListener>)this.keyListeners.get(key);
            if (listeners == null) {
                listeners = new ArrayList<DistributedReplicantManager.ReplicantListener>();
                this.keyListeners.put(key, listeners);
            }
            listeners.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(String key, DistributedReplicantManager.ReplicantListener subscriber) {
        Map map = this.keyListeners;
        synchronized (map) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(key);
            if (listeners == null) {
                return;
            }
            listeners.remove(subscriber);
            if (listeners.size() == 0) {
                this.keyListeners.remove(key);
            }
        }
    }

    public int getReplicantsViewId(String key) {
        Integer result = (Integer)this.intraviewIdCache.get(key);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public boolean isMasterReplica(String key) {
        if (this.trace) {
            this.log.trace((Object)("isMasterReplica, key=" + key));
        }
        if (!this.localReplicants.containsKey(key)) {
            if (this.trace) {
                this.log.trace((Object)("no localReplicants, key=" + key + ", isMasterReplica=false"));
            }
            return false;
        }
        Vector allNodes = this.partition.getCurrentView();
        Map repForKey = (Map)this.replicants.get(key);
        if (repForKey == null) {
            if (this.trace) {
                this.log.trace((Object)("no replicants, key=" + key + ", isMasterReplica=true"));
            }
            return true;
        }
        Vector replicaNodes = new Vector(repForKey.keySet());
        boolean isMasterReplica = false;
        for (int i = 0; i < allNodes.size(); ++i) {
            String aMember = (String)allNodes.elementAt(i);
            if (this.trace) {
                this.log.trace((Object)("Testing member: " + aMember));
            }
            if (replicaNodes.contains(aMember)) {
                if (!this.trace) break;
                this.log.trace((Object)"Member found in replicaNodes, isMasterReplica=false");
                break;
            }
            if (!aMember.equals(this.nodeName)) continue;
            if (this.trace) {
                this.log.trace((Object)"Member == nodeName, isMasterReplica=true");
            }
            isMasterReplica = true;
            break;
        }
        return isMasterReplica;
    }

    public void _add(String key, String nodeName, Serializable replicant) {
        if (this.trace) {
            this.log.trace((Object)("_add(" + key + ", " + nodeName));
        }
        try {
            this.addReplicant(key, nodeName, replicant);
            KeyChangeEvent kce = new KeyChangeEvent();
            kce.key = key;
            kce.replicants = this.lookupReplicants(key);
            this.asynchHandler.queueEvent(kce);
        }
        catch (Exception ex) {
            this.log.error((Object)"_add failed", (Throwable)ex);
        }
    }

    public void _remove(String key, String nodeName) {
        try {
            if (this.removeReplicant(key, nodeName)) {
                KeyChangeEvent kce = new KeyChangeEvent();
                kce.key = key;
                kce.replicants = this.lookupReplicants(key);
                this.asynchHandler.queueEvent(kce);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"_remove failed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeReplicant(String key, String nodeName) throws Exception {
        Map map = this.replicants;
        synchronized (map) {
            Map replicant = (Map)this.replicants.get(key);
            if (replicant == null) {
                return false;
            }
            Object removed = replicant.remove(nodeName);
            if (removed != null) {
                Collection values = replicant.values();
                if (values.size() == 0) {
                    this.replicants.remove(key);
                }
                return true;
            }
        }
        return false;
    }

    public Object[] lookupLocalReplicants() throws Exception {
        this.partitionNameKnown.acquire();
        Object[] rtn = new Object[]{this.nodeName, this.localReplicants};
        if (this.trace) {
            this.log.trace((Object)("lookupLocalReplicants called (" + rtn[0] + "). Return: " + this.localReplicants.size()));
        }
        return rtn;
    }

    protected int calculateReplicantsHash(List members) {
        int result = 0;
        Object obj = null;
        for (int i = 0; i < members.size(); ++i) {
            obj = members.get(i);
            if (obj == null) continue;
            result += obj.hashCode();
        }
        return result;
    }

    protected int updateReplicantsHashId(String key) {
        List nodes = this.lookupReplicantsNodeNames(key);
        int result = 0;
        if (nodes == null || nodes.size() == 0) {
            this.intraviewIdCache.remove(key);
        } else {
            result = this.calculateReplicantsHash(nodes);
            this.intraviewIdCache.put(key, new Integer(result));
        }
        return result;
    }

    protected void addReplicant(String key, String nodeName, Serializable replicant) {
        this.addReplicant(this.replicants, key, nodeName, replicant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReplicant(Map map, String key, String nodeName, Serializable replicant) {
        Map map2 = map;
        synchronized (map2) {
            HashMap<String, Serializable> rep = (HashMap<String, Serializable>)map.get(key);
            if (rep == null) {
                if (this.trace) {
                    this.log.trace((Object)"_adding new HashMap");
                }
                rep = new HashMap<String, Serializable>();
                map.put(key, rep);
            }
            rep.put(nodeName, replicant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getKeysReplicatedByNode(String nodeName) {
        Vector<String> result = new Vector<String>();
        Map map = this.replicants;
        synchronized (map) {
            for (String key : this.replicants.keySet()) {
                Map values = (Map)this.replicants.get(key);
                if (values == null || !values.containsKey(nodeName)) continue;
                result.add(key);
            }
        }
        return result;
    }

    protected boolean replicantEntryAlreadyExists(String key, String nodeName) {
        return this.replicantEntryAlreadyExists(this.replicants, key, nodeName);
    }

    protected boolean replicantEntryAlreadyExists(Map map, String key, String nodeName) {
        Map rep = (Map)map.get(key);
        if (rep == null) {
            return false;
        }
        return rep.containsKey(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyKeyListeners(String key, List newReplicants, boolean merge) {
        if (this.trace) {
            this.log.trace((Object)"notifyKeyListeners");
        }
        int newId = this.updateReplicantsHashId(key);
        ArrayList listeners = (ArrayList)this.keyListeners.get(key);
        if (listeners == null) {
            if (this.trace) {
                this.log.trace((Object)"listeners is null");
            }
            return;
        }
        DistributedReplicantManager.ReplicantListener[] toNotify = null;
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            toNotify = new DistributedReplicantManager.ReplicantListener[listeners.size()];
            toNotify = listeners.toArray(toNotify);
        }
        if (this.trace) {
            this.log.trace((Object)("notifying " + toNotify.length + " listeners for key change: " + key));
        }
        for (int i = 0; i < toNotify.length; ++i) {
            if (toNotify[i] == null) continue;
            toNotify[i].replicantsChanged(key, newReplicants, newId, merge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void republishLocalReplicants() {
        try {
            HashMap localReplicants;
            if (this.trace) {
                this.log.trace((Object)"Start Re-Publish local replicants in DRM");
            }
            Map map = this.localReplicants;
            synchronized (map) {
                localReplicants = new HashMap(this.localReplicants);
            }
            for (Map.Entry entry : localReplicants.entrySet()) {
                String key = (String)entry.getKey();
                Object replicant = entry.getValue();
                if (replicant == null) continue;
                if (this.trace) {
                    this.log.trace((Object)("publishing, key=" + key + ", value=" + replicant));
                }
                Object[] args = new Object[]{key, this.nodeName, replicant};
                this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_add", args, this.add_types, true);
                this.notifyKeyListeners(key, this.lookupReplicants(key), false);
            }
            if (this.trace) {
                this.log.trace((Object)"End Re-Publish local replicants");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Re-Publish failed", (Throwable)e);
        }
    }

    protected void mergeMembers() {
        try {
            this.log.debug((Object)"Start merging members in DRM service...");
            HashSet<String> notifies = new HashSet<String>();
            ArrayList rsp = this.partition.callMethodOnCluster(SERVICE_NAME, "lookupLocalReplicants", new Object[0], new Class[0], true);
            if (rsp.size() == 0) {
                this.log.debug((Object)"No responses from other nodes during the DRM merge process.");
            } else {
                this.log.debug((Object)("The DRM merge process has received " + rsp.size() + " answers"));
            }
            for (int i = 0; i < rsp.size(); ++i) {
                Object o = rsp.get(i);
                if (o == null) {
                    this.log.warn((Object)"As part of the answers received during the DRM merge process, a NULL message was received!");
                    continue;
                }
                if (o instanceof Throwable) {
                    this.log.warn((Object)"As part of the answers received during the DRM merge process, a Throwable was received!", (Throwable)o);
                    continue;
                }
                Object[] objs = (Object[])o;
                String node = (String)objs[0];
                Map replicants = (Map)objs[1];
                for (String key : replicants.keySet()) {
                    if (this.replicantEntryAlreadyExists(key, node)) continue;
                    this.addReplicant(key, node, (Serializable)replicants.get(key));
                    notifies.add(key);
                }
                Vector currentStatus = this.getKeysReplicatedByNode(node);
                if (currentStatus.size() <= replicants.size()) continue;
                int currentKeysMax = currentStatus.size();
                for (int currentKeysId = 0; currentKeysId < currentKeysMax; ++currentKeysId) {
                    String theKey = (String)currentStatus.elementAt(currentKeysId);
                    if (replicants.containsKey(theKey)) continue;
                    this.removeReplicant(theKey, node);
                    notifies.add(theKey);
                }
            }
            for (String key : notifies) {
                this.notifyKeyListeners(key, this.lookupReplicants(key), true);
            }
            this.log.debug((Object)"..Finished merging members in DRM service");
        }
        catch (Exception ex) {
            this.log.error((Object)"merge failed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeDeadMembers(Vector deadMembers, boolean merge) {
        if (deadMembers.size() <= 0) {
            return;
        }
        this.log.debug((Object)("purgeDeadMembers, " + deadMembers));
        try {
            Map map = this.replicants;
            synchronized (map) {
                for (String key : this.replicants.keySet()) {
                    Map replicant = (Map)this.replicants.get(key);
                    boolean modified = false;
                    for (int i = 0; i < deadMembers.size(); ++i) {
                        String node = deadMembers.elementAt(i).toString();
                        this.log.debug((Object)("trying to remove deadMember " + node + " for key " + key));
                        Object removed = replicant.remove(node);
                        if (removed != null) {
                            this.log.debug((Object)(node + " was removed"));
                            modified = true;
                            continue;
                        }
                        this.log.debug((Object)(node + " was NOT removed!!!"));
                    }
                    if (!modified) continue;
                    this.notifyKeyListeners(key, this.lookupReplicants(key), merge);
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"purgeDeadMembers failed", (Throwable)ex);
        }
    }

    protected void cleanupKeyListeners() {
    }

    protected static synchronized int nextThreadID() {
        return threadID++;
    }

    protected class MembersPublisher
    extends Thread {
        public MembersPublisher() {
            super("DRM Async Publisher#" + DistributedReplicantManagerImpl.nextThreadID());
        }

        public void run() {
            DistributedReplicantManagerImpl.this.log.debug((Object)"DRM: Sleeping before re-publishing for 50ms just in case");
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DistributedReplicantManagerImpl.this.republishLocalReplicants();
        }
    }

    protected class MergeMembers
    extends Thread {
        public MergeMembers() {
            super("DRM Async Merger#" + DistributedReplicantManagerImpl.nextThreadID());
        }

        public void run() {
            DistributedReplicantManagerImpl.this.log.debug((Object)"Sleeping for 50ms before mergeMembers");
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DistributedReplicantManagerImpl.this.mergeMembers();
        }
    }

    static class KeyChangeEvent {
        String key;
        List replicants;
        boolean merge;

        KeyChangeEvent() {
        }
    }
}

