/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.hasessionstate.server;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.hasessionstate.interfaces.HASessionState;
import org.jboss.ha.hasessionstate.interfaces.PackagedSession;
import org.jboss.ha.hasessionstate.server.PackagedSessionImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.NonSerializableFactory;

public class HASessionStateImpl
implements HASessionState,
HAPartition.HAPartitionStateTransfer {
    protected String _sessionStateName;
    protected Logger log;
    protected HAPartition hapGeneral;
    protected String sessionStateIdentifier;
    protected String myNodeName;
    protected long beanCleaningDelay;
    protected String haPartitionName;
    protected final long MAX_DELAY_BEFORE_CLEANING_UNRECLAIMED_STATE = 1800000L;
    protected static final String HA_SESSION_STATE_STATE_TRANSFER = "HASessionStateTransfer";
    protected HashMap locks = new HashMap();
    protected Hashtable appSessions = new Hashtable();
    protected Object lockAppSession = new Object();
    protected Hashtable listeners = new Hashtable();

    private HASessionStateImpl() {
    }

    public HASessionStateImpl(String sessionStateName, HAPartition partition, long beanCleaningDelay) {
        if (partition == null) {
            throw new IllegalArgumentException("HAPartition must not be null when constructing HASessionImpl");
        }
        this.hapGeneral = partition;
        this._sessionStateName = sessionStateName == null ? "/HASessionState/Default" : sessionStateName;
        this.sessionStateIdentifier = "SessionState-'" + this._sessionStateName + "'";
        this.haPartitionName = partition.getPartitionName();
        this.beanCleaningDelay = beanCleaningDelay > 0L ? beanCleaningDelay : 1800000L;
    }

    public void init() throws Exception {
        this.log = Logger.getLogger((String)(HASessionStateImpl.class.getName() + "." + this._sessionStateName));
        this.hapGeneral.registerRPCHandler(this.sessionStateIdentifier, (Object)this);
        this.hapGeneral.subscribeToStateTransferEvents(HA_SESSION_STATE_STATE_TRANSFER, (HAPartition.HAPartitionStateTransfer)this);
    }

    public void start() throws Exception {
        this.myNodeName = this.hapGeneral.getNodeName();
        this.log.debug((Object)("HASessionState node name : " + this.myNodeName));
        InitialContext ctx = new InitialContext();
        this.bind(this._sessionStateName, this, HASessionStateImpl.class, ctx);
    }

    protected void bind(String jndiName, Object who, Class classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext " + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.bind(n.get(0), (Object)ref);
    }

    public void stop() throws Exception {
        this.purgeState();
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this._sessionStateName);
            NonSerializableFactory.unbind((String)this._sessionStateName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() throws Exception {
        this.hapGeneral.unregisterRPCHandler(this.sessionStateIdentifier, (Object)this);
        this.hapGeneral.unsubscribeFromStateTransferEvents(HA_SESSION_STATE_STATE_TRANSFER, (HAPartition.HAPartitionStateTransfer)this);
    }

    public String getNodeName() {
        return this.myNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getCurrentState() {
        this.log.debug((Object)"Building and returning state of HASessionState");
        if (this.appSessions == null) {
            this.appSessions = new Hashtable();
        }
        byte[] result = null;
        Object object = this.lockAppSession;
        synchronized (object) {
            this.purgeState();
            try {
                result = this.deflate(this.appSessions);
            }
            catch (Exception e) {
                this.log.error((Object)"operation failed", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentState(Serializable newState) {
        this.log.debug((Object)"Receiving state of HASessionState");
        if (this.appSessions == null) {
            this.appSessions = new Hashtable();
        }
        Object object = this.lockAppSession;
        synchronized (object) {
            try {
                this.appSessions.clear();
                this.appSessions = (Hashtable)this.inflate((byte[])newState);
            }
            catch (Exception e) {
                this.log.error((Object)"operation failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeState() {
        Object object = this.lockAppSession;
        synchronized (object) {
            Enumeration keyEnum = this.appSessions.keys();
            while (keyEnum.hasMoreElements()) {
                Object key = keyEnum.nextElement();
                Hashtable value = (Hashtable)this.appSessions.get(key);
                long currentTime = System.currentTimeMillis();
                Iterator iterSessions = value.values().iterator();
                while (iterSessions.hasNext()) {
                    PackagedSession ps = (PackagedSession)iterSessions.next();
                    if (currentTime - ps.unmodifiedExistenceInVM() <= this.beanCleaningDelay) continue;
                    iterSessions.remove();
                }
            }
        }
    }

    protected byte[] deflate(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater def = new Deflater(9);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, def);
        ObjectOutputStream out = new ObjectOutputStream(dos);
        out.writeObject(object);
        out.close();
        dos.finish();
        dos.close();
        return baos.toByteArray();
    }

    protected Object inflate(byte[] compressedContent) throws IOException {
        if (compressedContent == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(new ByteArrayInputStream(compressedContent)));
            Object object = in.readObject();
            in.close();
            return object;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getHashtableForApp(String appName) {
        if (this.appSessions == null) {
            this.appSessions = new Hashtable();
        }
        Hashtable result = null;
        Object object = this.lockAppSession;
        synchronized (object) {
            result = (Hashtable)this.appSessions.get(appName);
            if (result == null) {
                result = new Hashtable();
                this.appSessions.put(appName, result);
            }
        }
        return result;
    }

    public void createSession(String appName, Object keyId) {
        this._createSession(appName, keyId);
    }

    public PackagedSessionImpl _createSession(String appName, Object keyId) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSessionImpl result = new PackagedSessionImpl((Serializable)keyId, null, this.myNodeName);
        app.put(keyId, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(String appName, Object keyId, byte[] state) throws RemoteException {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = (PackagedSession)app.get(keyId);
        if (ps == null) {
            ps = this._createSession(appName, keyId);
        }
        boolean isStateIdentical = false;
        Mutex mtx = this.getLock(appName, keyId);
        try {
            if (!mtx.attempt(0L)) {
                throw new RemoteException("Concurent calls on session object.");
            }
        }
        catch (InterruptedException ie) {
            this.log.info((Object)ie);
            return;
        }
        try {
            isStateIdentical = ps.setState(state);
            if (!isStateIdentical) {
                Object[] args = new Object[]{appName, ps};
                try {
                    this.hapGeneral.callMethodOnCluster(this.sessionStateIdentifier, "_setState", args, new Class[]{String.class, PackagedSession.class}, true);
                }
                catch (Exception e) {
                    this.log.error((Object)"operation failed", (Throwable)e);
                }
            }
        }
        finally {
            mtx.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _setState(String appName, PackagedSession session) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = (PackagedSession)app.get(session.getKey());
        if (ps == null) {
            ps = session;
            Hashtable hashtable = app;
            synchronized (hashtable) {
                app.put(ps.getKey(), ps);
            }
        }
        Mutex mtx = this.getLock(appName, session.getKey());
        try {
            mtx.acquire();
        }
        catch (InterruptedException ie) {
            this.log.info((Object)ie);
            return;
        }
        try {
            if (ps.getOwner().equals(this.myNodeName)) {
                this.ownedObjectExternallyModified(appName, session.getKey(), ps, session);
            }
            ps.update(session);
        }
        finally {
            mtx.release();
        }
    }

    public PackagedSession getState(String appName, Object keyId) {
        Hashtable app = this.getHashtableForApp(appName);
        return (PackagedSession)app.get(keyId);
    }

    public PackagedSession getStateWithOwnership(String appName, Object keyId) throws RemoteException {
        return this.localTakeOwnership(appName, keyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackagedSession localTakeOwnership(String appName, Object keyId) throws RemoteException {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = (PackagedSession)app.get(keyId);
        if (ps == null) {
            return null;
        }
        Mutex mtx = this.getLock(appName, keyId);
        try {
            if (!mtx.attempt(0L)) {
                throw new RemoteException("Concurent calls on session object.");
            }
        }
        catch (InterruptedException ie) {
            this.log.info((Object)ie);
            return null;
        }
        try {
            if (!ps.getOwner().equals(this.myNodeName)) {
                Object[] args = new Object[]{appName, keyId, this.myNodeName, new Long(ps.getVersion())};
                ArrayList answers = null;
                try {
                    answers = this.hapGeneral.callMethodOnCluster(this.sessionStateIdentifier, "_setOwnership", args, new Class[]{String.class, Object.class, String.class, Long.class}, true);
                }
                catch (Exception e) {
                    this.log.error((Object)"operation failed", (Throwable)e);
                }
                if (answers != null && answers.contains(Boolean.FALSE)) {
                    throw new RemoteException("Concurent calls on session object.");
                }
                ps.setOwner(this.myNodeName);
                PackagedSession packagedSession = ps;
                return packagedSession;
            }
            PackagedSession packagedSession = ps;
            return packagedSession;
        }
        finally {
            mtx.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean _setOwnership(String appName, Object keyId, String newOwner, Long remoteVersion) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = (PackagedSession)app.get(keyId);
        Boolean answer = Boolean.TRUE;
        Mutex mtx = this.getLock(appName, keyId);
        try {
            if (!mtx.attempt(0L)) {
                return Boolean.FALSE;
            }
        }
        catch (InterruptedException ie) {
            this.log.info((Object)ie);
            return Boolean.FALSE;
        }
        try {
            if (!ps.getOwner().equals(this.myNodeName)) {
                answer = Boolean.TRUE;
            } else if (ps.getVersion() > remoteVersion) {
                answer = Boolean.FALSE;
            } else {
                ps.setOwner(newOwner);
                this.ownedObjectExternallyModified(appName, keyId, ps, ps);
                answer = Boolean.TRUE;
            }
        }
        finally {
            mtx.release();
        }
        return answer;
    }

    public void takeOwnership(String appName, Object keyId) throws RemoteException {
        this.localTakeOwnership(appName, keyId);
    }

    public void removeSession(String appName, Object keyId) {
        PackagedSession ps;
        Hashtable app = this.getHashtableForApp(appName);
        if (app != null && (ps = (PackagedSession)app.remove(keyId)) != null) {
            this.removeLock(appName, keyId);
            Object[] args = new Object[]{appName, keyId};
            try {
                this.hapGeneral.callMethodOnCluster(this.sessionStateIdentifier, "_removeSession", args, new Class[]{String.class, Object.class}, true);
            }
            catch (Exception e) {
                this.log.error((Object)"operation failed", (Throwable)e);
            }
        }
    }

    public void _removeSession(String appName, Object keyId) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = null;
        ps = (PackagedSession)app.remove(keyId);
        if (ps != null && ps.getOwner().equals(this.myNodeName)) {
            this.ownedObjectExternallyModified(appName, keyId, ps, ps);
        }
        this.removeLock(appName, keyId);
    }

    public synchronized void subscribe(String appName, HASessionState.HASessionStateListener listener) {
        Vector<HASessionState.HASessionStateListener> members = (Vector<HASessionState.HASessionStateListener>)this.listeners.get(appName);
        if (members == null) {
            members = new Vector<HASessionState.HASessionStateListener>();
            this.listeners.put(appName, members);
        }
        if (!members.contains(listener)) {
            members.add(listener);
        }
    }

    public synchronized void unsubscribe(String appName, HASessionState.HASessionStateListener listener) {
        Vector members = (Vector)this.listeners.get(appName);
        if (members != null && members.contains(listener)) {
            members.remove(listener);
        }
    }

    public void ownedObjectExternallyModified(String appName, Object key, PackagedSession oldSession, PackagedSession newSession) {
        Vector members = (Vector)this.listeners.get(appName);
        if (members != null) {
            for (int i = 0; i < members.size(); ++i) {
                try {
                    ((HASessionState.HASessionStateListener)members.elementAt(i)).sessionExternallyModified(newSession);
                    continue;
                }
                catch (Throwable t) {
                    this.log.debug((Object)t);
                }
            }
        }
    }

    public HAPartition getCurrentHAPartition() {
        return this.hapGeneral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lockExists(String appName, Object key) {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            HashMap ls = (HashMap)this.locks.get(appName);
            if (ls == null) {
                return false;
            }
            return ls.get(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mutex getLock(String appName, Object key) {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            Mutex mutex;
            HashMap<Object, Mutex> ls = (HashMap<Object, Mutex>)this.locks.get(appName);
            if (ls == null) {
                ls = new HashMap<Object, Mutex>();
                this.locks.put(appName, ls);
            }
            if ((mutex = (Mutex)ls.get(key)) == null) {
                mutex = new Mutex();
                ls.put(key, mutex);
            }
            return mutex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLock(String appName, Object key) {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            HashMap ls = (HashMap)this.locks.get(appName);
            if (ls == null) {
                return;
            }
            ls.remove(key);
        }
    }
}

