/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.singleton.HASingletonElectionPolicyMBean;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HASingletonElectionPolicyBase
extends ServiceMBeanSupport
implements HASingletonElectionPolicyMBean {
    private String mSingletonName;
    private HAPartition mPartition;
    private String mPreferredMaster;

    @Override
    public void setSingletonName(String singletonName) {
        this.mSingletonName = singletonName;
        this.log.debug((Object)("set singleton name to " + this.mSingletonName));
    }

    @Override
    public String getSingletonName() {
        return this.mSingletonName;
    }

    @Override
    public void setPreferredMaster(String node) {
        this.mPreferredMaster = node;
    }

    @Override
    public String getPreferredMaster() {
        return this.mPreferredMaster;
    }

    @Override
    public void setHAPartition(HAPartition partition) {
        this.mPartition = partition;
    }

    @Override
    public HAPartition getHAPartition() {
        return this.mPartition;
    }

    @Override
    public ClusterNode elect() {
        List<ClusterNode> candidates = this.getCandidates();
        if (candidates == null) {
            throw new IllegalStateException("list of cluster node candidates where to run the singleton cannot be null");
        }
        if (null != this.mPreferredMaster) {
            this.log.debug((Object)("Checking if " + this.mPreferredMaster + " is in candidate list " + candidates));
            for (ClusterNode node : candidates) {
                if (!node.getName().equals(this.mPreferredMaster)) continue;
                return node;
            }
            InetAddress addr = null;
            int port = -1;
            int idx = this.mPreferredMaster.indexOf(58);
            if (idx > 0 && idx < this.mPreferredMaster.length() - 1) {
                String portString = this.mPreferredMaster.substring(idx + 1);
                String hostName = this.mPreferredMaster.substring(0, idx);
                try {
                    port = Integer.parseInt(portString);
                    addr = InetAddress.getByName(hostName);
                    this.log.debug((Object)("Parsed " + this.mPreferredMaster + " into " + addr + " and " + port));
                }
                catch (NumberFormatException nfe) {
                    this.log.debug((Object)(this.mPreferredMaster + " does not end in an int; cannot parse out a port"), (Throwable)nfe);
                }
                catch (UnknownHostException uhe) {
                    this.log.debug((Object)("Cannot extract InetAddress from " + this.mPreferredMaster), (Throwable)uhe);
                }
            }
            if (addr != null) {
                String rewritten = addr.getHostAddress() + ":" + port;
                if (this.mPreferredMaster.equals(rewritten)) {
                    rewritten = addr.getHostName() + ":" + port;
                }
                for (ClusterNode node : candidates) {
                    if (!node.getName().equals(rewritten)) continue;
                    return node;
                }
            }
        }
        return this.elect(candidates);
    }

    protected List<ClusterNode> getCandidates() {
        return this.getHAPartition().getDistributedReplicantManager().lookupReplicantsNodes(this.getSingletonName());
    }

    protected abstract ClusterNode elect(List<ClusterNode> var1);

    private AddressPort parseAddressPort(String nodeName) {
        InetAddress addr = null;
        int port = -1;
        int idx = nodeName.indexOf(58);
        if (idx > 0 && idx < nodeName.length() - 1) {
            String portString = nodeName.substring(idx + 1);
            String hostName = nodeName.substring(0, idx);
            try {
                port = Integer.parseInt(portString);
                addr = InetAddress.getByName(hostName);
                return new AddressPort(addr, port);
            }
            catch (NumberFormatException nfe) {
                this.log.debug((Object)(nodeName + " does not end in an int; cannot parse out a port"), (Throwable)nfe);
            }
            catch (UnknownHostException uhe) {
                this.log.debug((Object)("Cannot extract InetAddress from " + nodeName), (Throwable)uhe);
            }
        }
        return null;
    }

    private class AddressPort {
        private InetAddress address;
        private int port;

        private AddressPort(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }
    }
}

