/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.net.InetAddress;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jgroups.stack.IpAddress;

public class ClusterNodeImpl
implements ClusterNode {
    private static final long serialVersionUID = 2713397663824031616L;
    protected String id = null;
    protected String jgId = null;
    protected IpAddress originalJGAddress = null;

    public ClusterNodeImpl(IpAddress jgAddress) {
        this.id = jgAddress.getAdditionalData() == null ? jgAddress.getIpAddress().getHostAddress() + ":" + jgAddress.getPort() : new String(jgAddress.getAdditionalData());
        this.originalJGAddress = jgAddress;
        StringBuffer sb = new StringBuffer();
        InetAddress jgIPAddr = jgAddress.getIpAddress();
        if (jgIPAddr == null) {
            sb.append("<null>");
        } else if (jgIPAddr.isMulticastAddress()) {
            sb.append(jgIPAddr.getHostAddress());
        } else {
            sb.append(this.getShortName(this.getFastHostName(jgIPAddr)));
        }
        sb.append(":" + jgAddress.getPort());
        this.jgId = sb.toString();
    }

    public String getName() {
        return this.id;
    }

    public String getJGName() {
        return this.jgId;
    }

    public IpAddress getOriginalJGAddress() {
        return this.originalJGAddress;
    }

    public InetAddress getIpAddress() {
        return this.originalJGAddress.getIpAddress();
    }

    public int getPort() {
        return this.originalJGAddress.getPort();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof ClusterNodeImpl)) {
            throw new ClassCastException("ClusterNode.compareTo(): comparison between different classes");
        }
        ClusterNodeImpl other = (ClusterNodeImpl)o;
        return this.id.compareTo(other.id);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClusterNodeImpl)) {
            return false;
        }
        ClusterNodeImpl other = (ClusterNodeImpl)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    protected String getShortName(String hostname) {
        int index = hostname.indexOf(46);
        if (hostname == null) {
            return "";
        }
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            return hostname.substring(0, index);
        }
        return hostname;
    }

    private String getFastHostName(InetAddress address) {
        String result = null;
        String inetAddr = address.toString();
        int idx = inetAddr.indexOf(address.getHostAddress());
        int idx1 = inetAddr.lastIndexOf(47);
        result = idx1 == idx + 1 ? (idx1 == 0 ? address.getHostAddress() : inetAddr.substring(0, idx1)) : address.getHostAddress();
        return result;
    }
}

