/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.util;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.log4j.MDC;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.ha.framework.server.util.TopologyMonitorServiceMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;

public class TopologyMonitorService
extends ServiceMBeanSupport
implements TopologyMonitorServiceMBean,
HAPartition.AsynchHAMembershipListener {
    private static final String CHANGE_NAME = TopologyMonitorService.class.getName() + ".membershipChanged";
    private static Logger changeLog = Logger.getLogger((String)CHANGE_NAME);
    private String partitionName = ServerConfigUtil.getDefaultPartitionName();
    private HAPartition partition;
    private String hostname;
    private ObjectName triggerServiceName;

    protected void startService() throws Exception {
        if (this.partition == null) {
            this.partition = HAPartitionLocator.getHAPartitionLocator().getHAPartition(this.partitionName, null);
        }
        this.partition.registerMembershipListener((HAPartition.HAMembershipListener)this);
        this.log.info((Object)"Registered as MembershipListener");
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (IOException e) {
            this.log.warn((Object)"Failed to lookup local hostname", (Throwable)e);
            this.hostname = "<unknown>";
        }
    }

    protected void stopService() throws Exception {
        this.partition.unregisterMembershipListener((HAPartition.HAMembershipListener)this);
    }

    public String getPartitionName() {
        return this.partition == null ? this.partitionName : this.partition.getPartitionName();
    }

    public void setPartitionName(String name) {
        this.partitionName = name;
    }

    public void setPartition(HAPartition partition) {
        this.partition = partition;
    }

    public ObjectName getTriggerServiceName() {
        return this.triggerServiceName;
    }

    public void setTriggerServiceName(ObjectName triggerServiceName) {
        this.triggerServiceName = triggerServiceName;
    }

    public Vector getClusterNodes() {
        Vector view = null;
        try {
            InitialContext ctx = new InitialContext();
            String jndiName = "/HAPartition/" + this.partitionName;
            HAPartition partition = (HAPartition)ctx.lookup(jndiName);
            view = partition.getCurrentView();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to access HAPartition state", (Throwable)e);
        }
        return view;
    }

    public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
        AddressPort addrInfo;
        int m;
        MDC.put((String)"RegexEventEvaluator", (Object)"End membershipChange.*");
        ArrayList<AddressPort> removed = new ArrayList<AddressPort>();
        ArrayList<AddressPort> added = new ArrayList<AddressPort>();
        ArrayList<AddressPort> members = new ArrayList<AddressPort>();
        changeLog.info((Object)("Begin membershipChanged info, hostname=" + this.hostname));
        changeLog.info((Object)("DeadMembers: size=" + deadMembers.size()));
        for (m = 0; m < deadMembers.size(); ++m) {
            addrInfo = this.getMemberAddress(deadMembers.get(m));
            removed.add(addrInfo);
            changeLog.info((Object)addrInfo);
        }
        changeLog.info((Object)("NewMembers: size=" + newMembers.size()));
        for (m = 0; m < newMembers.size(); ++m) {
            addrInfo = this.getMemberAddress(newMembers.get(m));
            added.add(addrInfo);
            changeLog.info((Object)addrInfo);
        }
        changeLog.info((Object)("AllMembers: size=" + allMembers.size()));
        for (m = 0; m < allMembers.size(); ++m) {
            addrInfo = this.getMemberAddress(allMembers.get(m));
            members.add(addrInfo);
            changeLog.info((Object)addrInfo);
        }
        if (this.triggerServiceName != null) {
            changeLog.info((Object)("Invoking trigger service: " + this.triggerServiceName));
            try {
                Object[] params = new Object[]{removed, added, members, CHANGE_NAME};
                String[] sig = new String[]{"java.util.ArrayList", "java.util.ArrayList", "java.util.ArrayList", "java.lang.String"};
                this.server.invoke(this.triggerServiceName, "membershipChanged", params, sig);
            }
            catch (Throwable t) {
                changeLog.error((Object)("Failed to notify trigger service: " + this.triggerServiceName), t);
                this.log.debug((Object)("Failed to notify trigger service: " + this.triggerServiceName), t);
            }
        }
        changeLog.info((Object)("End membershipChanged info, hostname=" + this.hostname));
        MDC.remove((String)"RegexEventEvaluator");
    }

    private AddressPort getMemberAddress(Object addr) {
        AddressPort info = null;
        try {
            ClusterNode node = (ClusterNode)addr;
            InetAddress inetAddr = node.getIpAddress();
            Integer port = new Integer(node.getPort());
            info = new AddressPort(inetAddr, port);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to obtain InetAddress/port from addr: " + addr), (Throwable)e);
        }
        return info;
    }

    public static class AddressPort {
        InetAddress addr;
        Integer port;

        AddressPort(InetAddress addr, Integer port) {
            this.addr = addr;
            this.port = port;
        }

        public Integer getPort() {
            return this.port;
        }

        public InetAddress getInetAddress() {
            return this.addr;
        }

        public String getHostAddress() {
            return this.addr.getHostAddress();
        }

        public String getHostName() {
            return this.addr.getHostName();
        }

        public String toString() {
            return "{host(" + this.addr + "), port(" + this.port + ")}";
        }
    }
}

