/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.util.List;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.singleton.HASingletonElectionPolicyMBean;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HASingletonElectionPolicyBase
extends ServiceMBeanSupport
implements HASingletonElectionPolicyMBean {
    private String mSingletonName;
    private HAPartition mPartition;
    private String mPreferredMaster;

    @Override
    public void setSingletonName(String singletonName) {
        this.mSingletonName = singletonName;
        this.log.debug((Object)("set singleton name to " + this.mSingletonName));
    }

    @Override
    public String getSingletonName() {
        return this.mSingletonName;
    }

    public void setPreferredMaster(String node) {
        this.mPreferredMaster = node;
    }

    public String getPreferredMaster() {
        return this.mPreferredMaster;
    }

    @Override
    public void setHAPartition(HAPartition partition) {
        this.mPartition = partition;
    }

    @Override
    public HAPartition getHAPartition() {
        return this.mPartition;
    }

    @Override
    public ClusterNode elect() {
        List<ClusterNode> candidates = this.getCandidates();
        if (candidates == null) {
            this.log.debug((Object)"list of cluster node candidates where to run the singleton is null");
            return null;
        }
        return this.elect(candidates);
    }

    protected List<ClusterNode> getCandidates() {
        return this.getHAPartition().getDistributedReplicantManager().lookupReplicantsNodes(this.getSingletonName());
    }

    protected abstract ClusterNode elect(List<ClusterNode> var1);
}

