package org.jboss.ha.framework.server.deployers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public abstract class AbstractHAPartitionDependencyDeployer extends AbstractDeployer
{

   private HAPartitionDependencyCreator dependencyCreator;

   public AbstractHAPartitionDependencyDeployer()
   {
      super();     
      addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
      addOutput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
      setStage(DeploymentStages.POST_CLASSLOADER);
   }

   public synchronized HAPartitionDependencyCreator getHaPartitionDependencyCreator()
   {
      if (dependencyCreator == null)
      {
         dependencyCreator = DefaultHAPartitionDependencyCreator.INSTANCE;
      }
      return dependencyCreator;
   }

   public synchronized void setHaPartitionDependencyCreator(HAPartitionDependencyCreator dependencyCreator)
   {
      this.dependencyCreator = dependencyCreator;
   }

   /**
    * Adds the dependency to relevant metadata.
    * 
    * {@inheritDoc}
    */
   public void deploy(DeploymentUnit unit) throws DeploymentException
   {
      JBossMetaData metaData = unit.getAttachment(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME, JBossMetaData.class);
      if (metaData != null && accepts(metaData))
      {
         JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
         if (beans != null)
         {
            for (Iterator<JBossEnterpriseBeanMetaData> it = beans.iterator(); it.hasNext(); )
            {
               JBossEnterpriseBeanMetaData bmd = it.next();
               ClusterConfigMetaData ccmd = getClusteredBeanClusterConfig(bmd);
               if (ccmd != null)
               {
                  addHAPartitionDependency(bmd, ccmd);
               }
            }
         }
      }
   }
   
   protected abstract boolean accepts(JBossMetaData metaData);
   
   protected abstract void configureDeploymentStage();
   
   protected abstract ClusterConfigMetaData getClusteredBeanClusterConfig(JBossEnterpriseBeanMetaData bmd);

   private void addHAPartitionDependency(JBossEnterpriseBeanMetaData bmd, ClusterConfigMetaData ccmd)
   {
      String dependencyName = getHaPartitionDependencyCreator().getHAPartitionDependencyName(ccmd.getPartitionName());
      Set<String> depends = bmd.getDepends();
      if (depends == null)
      {
         depends = new HashSet<String>();
      }
      depends.add(dependencyName);
      bmd.setDepends(depends);
   }

}