/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.AsynchEventHandler;
import org.jboss.ha.framework.server.DistributedReplicantManagerImplMBean;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(isRuntime=true, properties=ManagementProperties.EXPLICIT)
public class DistributedReplicantManagerImpl
implements DistributedReplicantManagerImplMBean,
HAPartition.HAMembershipExtendedListener,
HAPartition.HAPartitionStateTransfer,
AsynchEventHandler.AsynchEventProcessor {
    static final String OBJECT_NAME_BASE = "jboss:service=DistributedReplicantManager";
    static final String SERVICE_NAME = "DistributedReplicantManager";
    private static final Class<?>[] add_types = new Class[]{String.class, String.class, Serializable.class};
    private static final Class<?>[] remove_types = new Class[]{String.class, String.class};
    private static final AtomicInteger threadID = new AtomicInteger();
    private final ConcurrentMap<String, Serializable> localReplicants = new ConcurrentHashMap<String, Serializable>();
    private final ConcurrentMap<String, ConcurrentMap<String, Serializable>> replicants = new ConcurrentHashMap<String, ConcurrentMap<String, Serializable>>();
    private final ConcurrentMap<String, List<DistributedReplicantManager.ReplicantListener>> keyListeners = new ConcurrentHashMap<String, List<DistributedReplicantManager.ReplicantListener>>();
    private Map<String, Integer> intraviewIdCache = new ConcurrentHashMap<String, Integer>();
    private final HAPartition partition;
    private final AsynchEventHandler asynchHandler;
    private final Logger log;
    private String nodeName = null;
    private volatile CountDownLatch partitionNameKnown = new CountDownLatch(1);

    public DistributedReplicantManagerImpl(HAPartition partition) {
        if (partition == null) {
            throw new NullPointerException("partition is null");
        }
        this.partition = partition;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + partition.getPartitionName()));
        this.asynchHandler = new AsynchEventHandler(this, "AsynchKeyChangeHandler");
    }

    public void createService() throws Exception {
        if (this.partition == null) {
            throw new IllegalStateException("HAPartition property must be set before creating DistributedReplicantManager service");
        }
        this.log.debug((Object)"registerRPCHandler");
        this.partition.registerRPCHandler(SERVICE_NAME, (Object)this);
        this.log.debug((Object)"subscribeToStateTransferEvents");
        this.partition.subscribeToStateTransferEvents(SERVICE_NAME, (HAPartition.HAPartitionStateTransfer)this);
        this.log.debug((Object)"registerMembershipListener");
        this.partition.registerMembershipListener((HAPartition.HAMembershipListener)this);
    }

    public void startService() throws Exception {
        this.nodeName = this.partition.getNodeName();
        this.asynchHandler.start();
        this.partitionNameKnown.countDown();
    }

    public void stopService() throws Exception {
        try {
            this.asynchHandler.stop();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to stop asynchHandler", (Throwable)e);
        }
        this.partitionNameKnown = new CountDownLatch(1);
    }

    public void destroyService() throws Exception {
        for (String key : this.localReplicants.keySet()) {
            this.removeLocal(key);
        }
        if (this.partition != null) {
            this.partition.unregisterRPCHandler(SERVICE_NAME, (Object)this);
            this.partition.unsubscribeFromStateTransferEvents(SERVICE_NAME, (HAPartition.HAPartitionStateTransfer)this);
            this.partition.unregisterMembershipListener((HAPartition.HAMembershipListener)this);
        }
    }

    public void registerWithJmx(MBeanServer server) throws Exception {
        server.registerMBean(this, this.getObjectName());
    }

    public void unregisterWithJmx(MBeanServer server) throws Exception {
        server.unregisterMBean(this.getObjectName());
    }

    private ObjectName getObjectName() throws Exception {
        return new ObjectName("jboss:service=DistributedReplicantManager,partition=" + this.partition.getPartitionName());
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, description="The partition's name")
    @ManagementObjectID(type="HAPartition")
    public String getPartitionName() {
        return this.partition.getPartitionName();
    }

    @Override
    @ManagementOperation(name="listDRMContent", description="List all known keys and the nodes that have registered bindings", impact=ManagedOperation.Impact.ReadOnly)
    public String listContent() throws Exception {
        StringBuilder result = new StringBuilder();
        result.append("<pre>");
        for (String category : this.getAllServices()) {
            result.append("-----------------------------------------------\n");
            result.append("Service : ").append(category).append("\n\n");
            Serializable local = (Serializable)this.localReplicants.get(category);
            if (local == null) {
                result.append("\t- Service is *not* available locally\n");
            } else {
                result.append("\t- Service *is* also available locally\n");
            }
            Map content = (Map)this.replicants.get(category);
            if (content != null) {
                for (String location : content.keySet()) {
                    result.append("\t- ").append(location).append("\n");
                }
            }
            result.append("\n");
        }
        result.append("</pre>");
        return result.toString();
    }

    @Override
    @ManagementOperation(name="listDRMContentAsXml", description="List in XML format all known services and the nodes that have registered bindings", impact=ManagedOperation.Impact.ReadOnly)
    public String listXmlContent() throws Exception {
        StringBuilder result = new StringBuilder();
        result.append("<ReplicantManager>\n");
        for (String category : this.getAllServices()) {
            Map content;
            result.append("\t<Service>\n");
            result.append("\t\t<ServiceName>").append(category).append("</ServiceName>\n");
            Serializable local = (Serializable)this.localReplicants.get(category);
            if (local != null) {
                result.append("\t\t<Location>\n");
                result.append("\t\t\t<Name local=\"True\">").append(this.nodeName).append("</Name>\n");
                result.append("\t\t</Location>\n");
            }
            if ((content = (Map)this.replicants.get(category)) != null) {
                for (String location : content.keySet()) {
                    result.append("\t\t<Location>\n");
                    result.append("\t\t\t<Name local=\"False\">").append(location).append("</Name>\n");
                    result.append("\t\t</Location>\n");
                }
            }
            result.append("\t</Service>\n");
        }
        result.append("</ReplicantManager>\n");
        return result.toString();
    }

    public Serializable getCurrentState() {
        HashMap result = new HashMap();
        for (String category : this.getAllServices()) {
            Serializable local;
            ConcurrentHashMap<String, Serializable> map = new ConcurrentHashMap<String, Serializable>();
            ConcurrentMap content = (ConcurrentMap)this.replicants.get(category);
            if (content != null) {
                map.putAll(content);
            }
            if ((local = (Serializable)this.localReplicants.get(category)) != null) {
                map.put(this.nodeName, local);
            }
            result.put(category, map);
        }
        return new Object[]{result, this.intraviewIdCache};
    }

    public void setCurrentState(Serializable newState) {
        Object[] globalState = (Object[])newState;
        Map map = (Map)globalState[0];
        this.replicants.putAll(map);
        this.intraviewIdCache = (Map)globalState[1];
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.nodeName + ": received new state, will republish local replicants"));
        }
        new MembersPublisher().start();
    }

    @ManagementOperation(name="getAllDRMServices", description="Get a collection of the names of all keys for which we have bindings", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<String> getAllServices() {
        HashSet<String> services = new HashSet<String>();
        services.addAll(this.localReplicants.keySet());
        services.addAll(this.replicants.keySet());
        return services;
    }

    public void membershipChangedDuringMerge(Vector deadMembers, Vector newMembers, Vector allMembers, Vector originatingGroups) {
        this.log.info((Object)"Merging partitions...");
        this.log.info((Object)("Dead members: " + deadMembers.size()));
        this.log.info((Object)("Originating groups: " + originatingGroups));
        this.purgeDeadMembers(deadMembers, true);
        if (newMembers.size() > 0) {
            new MergeMembers().start();
        }
    }

    public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
        this.log.info((Object)("I am (" + this.nodeName + ") received membershipChanged event:"));
        this.log.info((Object)("Dead members: " + deadMembers.size() + " (" + deadMembers + ")"));
        this.log.info((Object)("New Members : " + newMembers.size() + " (" + newMembers + ")"));
        this.log.info((Object)("All Members : " + allMembers.size() + " (" + allMembers + ")"));
        this.purgeDeadMembers(deadMembers, false);
    }

    @Override
    public void processEvent(Object event) {
        KeyChangeEvent kce = (KeyChangeEvent)event;
        this.notifyKeyListeners(kce.key, kce.replicants, kce.merge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, Serializable replicant) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("add, key=" + key + ", value=" + replicant));
        }
        this.partitionNameKnown.await();
        Object[] args = new Object[]{key, this.nodeName, replicant};
        this.partition.callMethodOnCluster(SERVICE_NAME, "_add", args, (Class[])add_types, true);
        List<Serializable> replicants = null;
        ConcurrentMap<String, Serializable> concurrentMap = this.localReplicants;
        synchronized (concurrentMap) {
            this.localReplicants.put(key, replicant);
            replicants = this.getReplicants(key);
        }
        this.notifyKeyListeners(key, replicants, false);
    }

    public void remove(String key) throws Exception {
        this.partitionNameKnown.await();
        if (this.localReplicants.containsKey(key)) {
            Object[] args = new Object[]{key, this.nodeName};
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_remove", args, (Class[])remove_types, true);
            this.removeLocal(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLocal(String key) {
        List<Serializable> replicants = null;
        ConcurrentMap<String, Serializable> concurrentMap = this.localReplicants;
        synchronized (concurrentMap) {
            if (this.localReplicants.remove(key) != null) {
                replicants = this.getReplicants(key);
            }
        }
        if (replicants != null) {
            this.notifyKeyListeners(key, replicants, false);
        }
    }

    public Serializable lookupLocalReplicant(String key) {
        return (Serializable)this.localReplicants.get(key);
    }

    public List<Serializable> lookupReplicants(String key) {
        Serializable local = (Serializable)this.localReplicants.get(key);
        Map replicant = (Map)this.replicants.get(key);
        if (replicant == null) {
            return local != null ? Collections.singletonList(local) : null;
        }
        ClusterNode[] nodes = this.partition.getClusterNodes();
        ArrayList<Serializable> result = new ArrayList<Serializable>(nodes.length);
        for (ClusterNode node : nodes) {
            String name = node.getName();
            if (local != null && this.nodeName.equals(name)) {
                result.add(local);
                continue;
            }
            Serializable value = (Serializable)replicant.get(name);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    private List<Serializable> getReplicants(String key) {
        List<Serializable> result = this.lookupReplicants(key);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Deprecated
    @ManagementOperation(name="lookupDRMNodeNames", description="Returns the names of the nodes that have registered objects under the given key", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="key", description="The name of the service")})
    public List<String> lookupReplicantsNodeNames(String key) {
        List<ClusterNode> nodes = this.lookupReplicantsNodes(key);
        if (nodes == null) {
            return null;
        }
        ArrayList<String> nodeNames = new ArrayList<String>(nodes.size());
        for (ClusterNode node : nodes) {
            nodeNames.add(node.getName());
        }
        return nodeNames;
    }

    public List<ClusterNode> lookupReplicantsNodes(String key) {
        boolean local = this.localReplicants.containsKey(key);
        Map replicant = (Map)this.replicants.get(key);
        if (replicant == null) {
            return local ? Collections.singletonList(this.partition.getClusterNode()) : null;
        }
        Set keys = replicant.keySet();
        ClusterNode[] nodes = this.partition.getClusterNodes();
        ArrayList<ClusterNode> rtn = new ArrayList<ClusterNode>(nodes.length);
        for (ClusterNode node : nodes) {
            String name = node.getName();
            if (local && this.nodeName.equals(name)) {
                rtn.add(this.partition.getClusterNode());
                continue;
            }
            if (!keys.contains(name)) continue;
            rtn.add(node);
        }
        return rtn;
    }

    public void registerListener(String key, DistributedReplicantManager.ReplicantListener subscriber) {
        CopyOnWriteArrayList<DistributedReplicantManager.ReplicantListener> list = new CopyOnWriteArrayList<DistributedReplicantManager.ReplicantListener>();
        CopyOnWriteArrayList<DistributedReplicantManager.ReplicantListener> existing = this.keyListeners.putIfAbsent(key, list);
        (existing != null ? existing : list).add(subscriber);
    }

    public void unregisterListener(String key, DistributedReplicantManager.ReplicantListener subscriber) {
        List listeners = (List)this.keyListeners.get(key);
        if (listeners != null) {
            listeners.remove(subscriber);
            this.keyListeners.remove(key, Collections.emptyList());
        }
    }

    @ManagementOperation(name="getDRMServiceViewId", description="Returns a hash of the list of nodes that have registered an object for the given key", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="key", description="The name of the service")})
    public int getReplicantsViewId(String key) {
        Integer result = this.intraviewIdCache.get(key);
        return result != null ? result : 0;
    }

    @ManagementOperation(name="isDRMMasterForService", description="Returns whether the DRM considers this node to be the master for the given service", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="key", description="The name of the service")})
    public boolean isMasterReplica(String key) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("isMasterReplica, key=" + key));
        }
        if (!this.localReplicants.containsKey(key)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("no localReplicants, key=" + key + ", isMasterReplica=false"));
            }
            return false;
        }
        Map repForKey = (Map)this.replicants.get(key);
        if (repForKey == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("no replicants, key=" + key + ", isMasterReplica=true"));
            }
            return true;
        }
        Vector allNodes = this.partition.getCurrentView();
        for (String node : allNodes) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Testing member: " + node));
            }
            if (repForKey.containsKey(node)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Member found in replicaNodes, isMasterReplica=false");
                }
                return false;
            }
            if (!node.equals(this.nodeName)) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Member == nodeName, isMasterReplica=true");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _add(String key, String nodeName, Serializable replicant) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_add(" + key + ", " + nodeName));
        }
        KeyChangeEvent event = new KeyChangeEvent();
        event.key = key;
        ConcurrentMap<String, ConcurrentMap<String, Serializable>> concurrentMap = this.replicants;
        synchronized (concurrentMap) {
            this.addReplicant(key, nodeName, replicant);
            event.replicants = this.getReplicants(key);
        }
        try {
            this.asynchHandler.queueEvent(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error((Object)"_add failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _remove(String key, String nodeName) {
        KeyChangeEvent event = new KeyChangeEvent();
        event.key = key;
        ConcurrentMap<String, ConcurrentMap<String, Serializable>> concurrentMap = this.replicants;
        synchronized (concurrentMap) {
            if (this.removeReplicant(key, nodeName)) {
                event.replicants = this.getReplicants(key);
            }
        }
        if (event.replicants != null) {
            try {
                this.asynchHandler.queueEvent(event);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.error((Object)"_remove failed", (Throwable)e);
            }
        }
    }

    protected boolean removeReplicant(String key, String nodeName) {
        Map replicant = (Map)this.replicants.get(key);
        if (replicant != null && replicant.remove(nodeName) != null) {
            this.replicants.remove(key, Collections.emptyMap());
            return true;
        }
        return false;
    }

    public Object[] lookupLocalReplicants() throws Exception {
        this.partitionNameKnown.await();
        Object[] rtn = new Object[]{this.nodeName, this.localReplicants};
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("lookupLocalReplicants called (" + rtn[0] + "). Return: " + this.localReplicants.size()));
        }
        return rtn;
    }

    protected int calculateReplicantsHash(List<ClusterNode> members) {
        int result = 0;
        for (ClusterNode member : members) {
            if (member == null) continue;
            result += member.getName().hashCode();
        }
        return result;
    }

    protected int updateReplicantsHashId(String key) {
        List<ClusterNode> nodes = this.lookupReplicantsNodes(key);
        int result = 0;
        if (nodes == null || nodes.isEmpty()) {
            this.intraviewIdCache.remove(key);
        } else {
            result = this.calculateReplicantsHash(nodes);
            this.intraviewIdCache.put(key, new Integer(result));
        }
        return result;
    }

    protected boolean addReplicant(String key, String nodeName, Serializable replicant) {
        ConcurrentHashMap<String, Serializable> map = new ConcurrentHashMap<String, Serializable>();
        ConcurrentHashMap<String, Serializable> existingMap = this.replicants.putIfAbsent(key, map);
        return (existingMap != null ? existingMap : map).put(nodeName, replicant) != null;
    }

    protected void notifyKeyListeners(String key, List<Serializable> newReplicants, boolean merge) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"notifyKeyListeners");
        }
        int newId = this.updateReplicantsHashId(key);
        List listeners = (List)this.keyListeners.get(key);
        if (listeners == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"listeners is null");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("notifying " + listeners.size() + " listeners for key change: " + key));
        }
        for (DistributedReplicantManager.ReplicantListener listener : listeners) {
            if (listener == null) continue;
            listener.replicantsChanged(key, newReplicants, newId, merge);
        }
    }

    protected void republishLocalReplicants() {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Start Re-Publish local replicants in DRM");
            }
            for (Map.Entry entry : this.localReplicants.entrySet()) {
                Serializable replicant = (Serializable)entry.getValue();
                if (replicant == null) continue;
                String key = (String)entry.getKey();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("publishing, key=" + key + ", value=" + replicant));
                }
                Object[] args = new Object[]{key, this.nodeName, replicant};
                this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_add", args, (Class[])add_types, true);
                this.notifyKeyListeners(key, this.getReplicants(key), false);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"End Re-Publish local replicants");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Re-Publish failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeMembers() {
        try {
            this.log.debug((Object)"Start merging members in DRM service...");
            ArrayList rsp = this.partition.callMethodOnCluster(SERVICE_NAME, "lookupLocalReplicants", new Object[0], new Class[0], true);
            if (rsp.isEmpty()) {
                this.log.debug((Object)"No responses from other nodes during the DRM merge process.");
            } else {
                this.log.debug((Object)("The DRM merge process has received " + rsp.size() + " answers"));
            }
            HashMap notifications = new HashMap();
            ConcurrentMap<String, ConcurrentMap<String, Serializable>> concurrentMap = this.replicants;
            synchronized (concurrentMap) {
                for (Object e : rsp) {
                    String key;
                    if (e == null) {
                        this.log.warn((Object)"As part of the answers received during the DRM merge process, a NULL message was received!");
                        continue;
                    }
                    if (e instanceof Throwable) {
                        this.log.warn((Object)"As part of the answers received during the DRM merge process, a Throwable was received!", (Throwable)e);
                        continue;
                    }
                    Object[] objs = (Object[])e;
                    String node = (String)objs[0];
                    Map replicants = (Map)objs[1];
                    for (Map.Entry entry : replicants.entrySet()) {
                        key = (String)entry.getKey();
                        if (!this.addReplicant(key, node, (Serializable)entry.getValue())) continue;
                        notifications.put(key, null);
                    }
                    for (Map.Entry entry : this.replicants.entrySet()) {
                        key = (String)entry.getKey();
                        if (!((ConcurrentMap)entry.getValue()).containsKey(node) || replicants.containsKey(key) || !this.removeReplicant(key, node)) continue;
                        notifications.put(key, null);
                    }
                }
                for (Map.Entry entry : notifications.entrySet()) {
                    entry.setValue(this.getReplicants((String)entry.getKey()));
                }
            }
            for (Map.Entry entry : notifications.entrySet()) {
                this.notifyKeyListeners((String)entry.getKey(), (List)entry.getValue(), true);
            }
            this.log.debug((Object)"..Finished merging members in DRM service");
        }
        catch (Exception ex) {
            this.log.error((Object)"merge failed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeDeadMembers(Vector<ClusterNode> deadMembers, boolean merge) {
        if (deadMembers.isEmpty()) {
            return;
        }
        this.log.debug((Object)("purgeDeadMembers, " + deadMembers));
        ArrayList<String> deadNodes = new ArrayList<String>(deadMembers.size());
        for (ClusterNode clusterNode : deadMembers) {
            deadNodes.add(clusterNode.getName());
        }
        for (Map.Entry entry : this.replicants.entrySet()) {
            String key = (String)entry.getKey();
            ConcurrentMap replicant = (ConcurrentMap)entry.getValue();
            List<Serializable> replicants = null;
            ConcurrentMap<String, ConcurrentMap<String, Serializable>> concurrentMap = this.replicants;
            synchronized (concurrentMap) {
                if (replicant.keySet().removeAll(deadNodes)) {
                    replicants = this.getReplicants(key);
                }
            }
            if (replicants == null) continue;
            this.notifyKeyListeners(key, replicants, merge);
        }
    }

    protected void cleanupKeyListeners() {
    }

    protected class MembersPublisher
    extends Thread {
        public MembersPublisher() {
            super("DRM Async Publisher#" + threadID.getAndIncrement());
        }

        public void run() {
            DistributedReplicantManagerImpl.this.log.debug((Object)"DRM: Sleeping before re-publishing for 50ms just in case");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            DistributedReplicantManagerImpl.this.republishLocalReplicants();
        }
    }

    protected class MergeMembers
    extends Thread {
        public MergeMembers() {
            super("DRM Async Merger#" + threadID.getAndIncrement());
        }

        public void run() {
            DistributedReplicantManagerImpl.this.log.debug((Object)"Sleeping for 50ms before mergeMembers");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            DistributedReplicantManagerImpl.this.mergeMembers();
        }
    }

    static class KeyChangeEvent {
        String key;
        List<Serializable> replicants;
        boolean merge;

        KeyChangeEvent() {
        }
    }
}

