/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.unified.server;

import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerHA;
import org.jboss.invocation.unified.interfaces.UnifiedInvokerHAProxy;
import org.jboss.invocation.unified.server.UnifiedInvoker;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.remoting.InvocationRequest;
import org.jboss.system.Registry;
import org.jboss.util.UnreachableStatementException;

public class UnifiedInvokerHA
extends UnifiedInvoker
implements InvokerHA {
    private HashMap<Integer, HATarget> beanMap = new HashMap();

    public UnifiedInvokerHA() {
        this.setSubSystem("invokerha");
    }

    protected void jmxBind() {
        Registry.bind((Object)this.getServiceName(), (Object)this);
    }

    public Serializable getStub() {
        return this.getInvoker().getLocator();
    }

    public void registerBean(ObjectName beanName, HATarget target) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        if (this.beanMap.containsKey(hash)) {
            this.log.debug((Object)("Trying to register target " + target + " using an existing hashCode. Already registered: " + hash + "=" + this.beanMap.get(hash)));
            throw new IllegalStateException("Trying to register target using an existing hashCode.");
        }
        this.beanMap.put(hash, target);
    }

    public Invoker createProxy(ObjectName beanName, LoadBalancePolicy policy, String proxyFamilyName) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        HATarget target = this.beanMap.get(hash);
        if (target == null) {
            throw new IllegalStateException("The bean hashCode not found");
        }
        String familyName = proxyFamilyName;
        if (familyName == null) {
            familyName = target.getAssociatedPartition().getPartitionName() + "/" + beanName;
        }
        return this.createProxy(this.getStrictRMIException(), target.getReplicants(), policy, proxyFamilyName, target.getCurrentViewId());
    }

    public void unregisterBean(ObjectName beanName) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        this.beanMap.remove(hash);
    }

    public Object invoke(InvocationRequest invocationReq) throws Throwable {
        Invocation invocation = (Invocation)invocationReq.getParameter();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCl = currentThread.getContextClassLoader();
        ObjectName mbean = null;
        try {
            mbean = (ObjectName)Registry.lookup((Object)invocation.getObjectName());
            long clientViewId = (Long)invocation.getValue((Object)"CLUSTER_VIEW_ID");
            HATarget target = this.beanMap.get(invocation.getObjectName());
            if (target == null) {
                throw new GenericClusteringException(1, "target is not/no more registered on this node");
            }
            if (!target.invocationsAllowed()) {
                throw new GenericClusteringException(1, "invocations are currently not allowed on this target");
            }
            Object obj = this.getServer().invoke(mbean, "invoke", new Object[]{invocation}, Invocation.INVOKE_SIGNATURE);
            HARMIResponse haResponse = new HARMIResponse();
            if (clientViewId != target.getCurrentViewId()) {
                haResponse.newReplicants = new ArrayList(target.getReplicants());
                haResponse.currentViewId = target.getCurrentViewId();
            }
            haResponse.response = obj;
            MarshalledObject<HARMIResponse> marshalledObject = new MarshalledObject<HARMIResponse>(haResponse);
            return marshalledObject;
        }
        catch (InstanceNotFoundException e) {
            throw new GenericClusteringException(1, (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new GenericClusteringException(1, (Throwable)e);
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
            throw new UnreachableStatementException();
        }
        finally {
            currentThread.setContextClassLoader(oldCl);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ObjectName result = super.preRegister(server, name);
        this.log.info((Object)("Service name is " + this.getServiceName()));
        return result;
    }

    protected Invoker createProxy(boolean isStrictRMIException, ArrayList targets, LoadBalancePolicy policy, String proxyFamilyName, long viewId) {
        return new UnifiedInvokerHAProxy(this.getInvoker().getLocator(), isStrictRMIException, targets, policy, proxyFamilyName, viewId);
    }
}

