/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.net.InetAddress;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.server.AddressPort;
import org.jgroups.Address;

public class ClusterNodeImpl
implements ClusterNode {
    private static final long serialVersionUID = -1831036833785680731L;
    protected final String id;
    protected String jgId = null;
    protected final Address originalJGAddress;
    protected final AddressPort address;

    public ClusterNodeImpl(Address jgAddress, AddressPort a) {
        this.address = a;
        this.originalJGAddress = jgAddress;
        this.id = a != null ? a.getHostAddress() + ":" + a.getPort() : jgAddress.toString();
    }

    public String getName() {
        return this.id;
    }

    public String getJGName() {
        if (this.jgId == null) {
            this.jgId = this.createJGName();
        }
        return this.jgId;
    }

    public Address getOriginalJGAddress() {
        return this.originalJGAddress;
    }

    public InetAddress getIpAddress() {
        return this.address.getInetAddress();
    }

    public int getPort() {
        return this.address.getPort();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof ClusterNodeImpl)) {
            throw new ClassCastException("ClusterNode.compareTo(): comparison between different classes");
        }
        ClusterNodeImpl other = (ClusterNodeImpl)o;
        return this.id.compareTo(other.id);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClusterNodeImpl)) {
            return false;
        }
        ClusterNodeImpl other = (ClusterNodeImpl)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    protected String getShortName(String hostname) {
        int index = hostname.indexOf(46);
        if (hostname == null) {
            return "";
        }
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            return hostname.substring(0, index);
        }
        return hostname;
    }

    protected String createJGName() {
        StringBuffer sb = new StringBuffer();
        InetAddress jgIPAddr = this.address.getInetAddress();
        if (jgIPAddr == null) {
            sb.append("<null>");
        } else if (jgIPAddr.isMulticastAddress()) {
            sb.append(jgIPAddr.getHostAddress());
        } else {
            sb.append(this.getShortName(ClusterNodeImpl.getFastHostName(jgIPAddr)));
        }
        sb.append(":" + this.address.getPort());
        return sb.toString();
    }

    private static String getFastHostName(InetAddress address) {
        String result = null;
        String hostAddress = address.getHostAddress();
        String inetAddr = address.toString();
        int idx = inetAddr.lastIndexOf(47);
        int idx1 = inetAddr.indexOf(hostAddress);
        result = idx1 == idx + 1 ? (idx == 0 ? hostAddress : inetAddr.substring(0, idx)) : hostAddress;
        return result;
    }
}

