/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.hasessionstate.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.hasessionstate.interfaces.HASessionState;
import org.jboss.ha.hasessionstate.interfaces.PackagedSession;
import org.jboss.ha.hasessionstate.server.PackagedSessionImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.NonSerializableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HASessionStateImpl
implements HASessionState,
HAPartition.HAPartitionStateTransfer {
    private static final long MAX_DELAY_BEFORE_CLEANING_UNRECLAIMED_STATE = 1800000L;
    private static final String HA_SESSION_STATE_STATE_TRANSFER = "HASessionStateTransfer";
    private static final Class<?>[] SET_OWNERSHIP_TYPES = new Class[]{String.class, Object.class, String.class, Long.class};
    private static final Class<?>[] REMOVE_SESSION_TYPES = new Class[]{String.class, Object.class};
    private static final Class<?>[] SET_STATE_TYPES = new Class[]{String.class, PackagedSession.class};
    protected Map<String, ConcurrentMap<Object, PackagedSession>> appSessionMap = new HashMap<String, ConcurrentMap<Object, PackagedSession>>();
    protected ConcurrentMap<String, Set<HASessionState.HASessionStateListener>> appListenerMap = new ConcurrentHashMap<String, Set<HASessionState.HASessionStateListener>>();
    long beanCleaningDelay;
    private String _sessionStateName;
    private Logger log;
    private HAPartition partition;
    private String sessionStateIdentifier;
    private String myNodeName;

    public HASessionStateImpl(String sessionStateName, HAPartition partition, long beanCleaningDelay) {
        if (partition == null) {
            throw new IllegalArgumentException("HAPartition must not be null when constructing HASessionImpl");
        }
        this.partition = partition;
        this._sessionStateName = sessionStateName != null ? sessionStateName : "/HASessionState/Default";
        this.sessionStateIdentifier = "SessionState-'" + this._sessionStateName + "'";
        this.beanCleaningDelay = beanCleaningDelay > 0L ? beanCleaningDelay : 1800000L;
        this.log = Logger.getLogger((String)(HASessionStateImpl.class.getName() + "." + this._sessionStateName));
    }

    @Override
    public void init() throws Exception {
        this.partition.registerRPCHandler(this.sessionStateIdentifier, (Object)this);
        this.partition.subscribeToStateTransferEvents(HA_SESSION_STATE_STATE_TRANSFER, (HAPartition.HAPartitionStateTransfer)this);
    }

    @Override
    public void start() throws Exception {
        this.myNodeName = this.partition.getNodeName();
        this.log.debug((Object)("HASessionState node name : " + this.myNodeName));
        InitialContext ctx = new InitialContext();
        this.bind(this._sessionStateName, this, HASessionStateImpl.class, ctx);
    }

    protected void bind(String jndiName, Object who, Class<?> classType, Context ctx) throws Exception {
        org.jboss.util.naming.NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext " + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.bind(n.get(0), (Object)ref);
    }

    public void stop() {
        this.purgeState();
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this._sessionStateName);
            org.jboss.util.naming.NonSerializableFactory.unbind((String)this._sessionStateName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void destroy() throws Exception {
        this.partition.unregisterRPCHandler(this.sessionStateIdentifier, (Object)this);
        this.partition.unsubscribeFromStateTransferEvents(HA_SESSION_STATE_STATE_TRANSFER, (HAPartition.HAPartitionStateTransfer)this);
    }

    @Override
    public String getNodeName() {
        return this.myNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getCurrentState() {
        this.log.debug((Object)"Building and returning state of HASessionState");
        Map<String, ConcurrentMap<Object, PackagedSession>> map = this.appSessionMap;
        synchronized (map) {
            this.purgeState();
            try {
                return this.deflate(this.appSessionMap);
            }
            catch (IOException e) {
                this.log.error((Object)"operation failed", (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentState(Serializable newState) {
        this.log.debug((Object)"Receiving state of HASessionState");
        try {
            Map map = (Map)this.inflate((byte[])newState);
            Map<String, ConcurrentMap<Object, PackagedSession>> map2 = this.appSessionMap;
            synchronized (map2) {
                this.appSessionMap.clear();
                this.appSessionMap.putAll(map);
            }
        }
        catch (IOException e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeState() {
        Map<String, ConcurrentMap<Object, PackagedSession>> map = this.appSessionMap;
        synchronized (map) {
            long currentTime = System.currentTimeMillis();
            for (ConcurrentMap<Object, PackagedSession> map2 : this.appSessionMap.values()) {
                for (PackagedSession session : map2.values()) {
                    if (currentTime - session.unmodifiedExistenceInVM() <= this.beanCleaningDelay) continue;
                    map2.remove(session.getKey());
                }
            }
        }
    }

    protected byte[] deflate(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater def = new Deflater(9);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, def);
        ObjectOutputStream out = new ObjectOutputStream(dos);
        out.writeObject(object);
        out.close();
        dos.finish();
        dos.close();
        return baos.toByteArray();
    }

    protected Object inflate(byte[] compressedContent) throws IOException {
        if (compressedContent == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(new ByteArrayInputStream(compressedContent)));
            Object object = in.readObject();
            in.close();
            return object;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentMap<Object, PackagedSession> getAppMap(String appName) {
        Map<String, ConcurrentMap<Object, PackagedSession>> map = this.appSessionMap;
        synchronized (map) {
            ConcurrentMap<Object, PackagedSession> map2 = this.appSessionMap.get(appName);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<Object, PackagedSession>();
                this.appSessionMap.put(appName, map2);
            }
            return map2;
        }
    }

    @Override
    public void createSession(String appName, Object keyId) {
        this._createSession(appName, keyId);
    }

    public PackagedSession _createSession(String appName, Object keyId) {
        PackagedSession session = this.createSession(keyId);
        this.getAppMap(appName).put(keyId, session);
        return session;
    }

    private PackagedSession createSession(Object keyId) {
        return new PackagedSessionImpl((Serializable)keyId, null, this.myNodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(String appName, Object keyId, byte[] state) throws RemoteException {
        Lock lock;
        PackagedSession session = this.createSession(keyId);
        PackagedSession existing = this.getAppMap(appName).putIfAbsent(keyId, session);
        if (existing != null) {
            session = existing;
        }
        if (!(lock = session.getLock()).tryLock()) {
            throw new RemoteException("Concurent calls on session object.");
        }
        try {
            boolean isStateIdentical = session.setState(state);
            if (!isStateIdentical) {
                Object[] args = new Object[]{appName, session};
                this.partition.callMethodOnCluster(this.sessionStateIdentifier, "_setState", args, (Class[])SET_STATE_TYPES, true);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _setState(String appName, PackagedSession session) {
        PackagedSession existing = this.getAppMap(appName).putIfAbsent(session.getKey(), session);
        if (existing != null) {
            Lock lock = existing.getLock();
            try {
                lock.lockInterruptibly();
            }
            catch (InterruptedException ie) {
                this.log.info((Object)ie);
                return;
            }
            try {
                if (existing.getOwner().equals(this.myNodeName)) {
                    this.ownedObjectExternallyModified(appName, session.getKey(), existing, session);
                }
                existing.update(session);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public PackagedSession getState(String appName, Object keyId) {
        return (PackagedSession)this.getAppMap(appName).get(keyId);
    }

    @Override
    public PackagedSession getStateWithOwnership(String appName, Object keyId) throws RemoteException {
        return this.localTakeOwnership(appName, keyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackagedSession localTakeOwnership(String appName, Object keyId) throws RemoteException {
        PackagedSession session = (PackagedSession)this.getAppMap(appName).get(keyId);
        if (session == null) {
            return null;
        }
        Lock lock = session.getLock();
        if (!lock.tryLock()) {
            throw new RemoteException("Concurent calls on session object.");
        }
        try {
            if (!session.getOwner().equals(this.myNodeName)) {
                Object[] args = new Object[]{appName, keyId, this.myNodeName, new Long(session.getVersion())};
                ArrayList answers = null;
                try {
                    answers = this.partition.callMethodOnCluster(this.sessionStateIdentifier, "_setOwnership", args, (Class[])SET_OWNERSHIP_TYPES, true);
                }
                catch (Exception e) {
                    this.log.error((Object)"operation failed", (Throwable)e);
                }
                if (answers != null && answers.contains(Boolean.FALSE)) {
                    throw new RemoteException("Concurent calls on session object.");
                }
                session.setOwner(this.myNodeName);
                PackagedSession packagedSession = session;
                return packagedSession;
            }
            PackagedSession packagedSession = session;
            return packagedSession;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean _setOwnership(String appName, Object keyId, String newOwner, Long remoteVersion) {
        PackagedSession session = (PackagedSession)this.getAppMap(appName).get(keyId);
        Lock lock = session.getLock();
        if (!lock.tryLock()) {
            return Boolean.FALSE;
        }
        try {
            if (!session.getOwner().equals(this.myNodeName)) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            if (session.getVersion() > remoteVersion) {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            session.setOwner(newOwner);
            this.ownedObjectExternallyModified(appName, keyId, session, session);
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void takeOwnership(String appName, Object keyId) throws RemoteException {
        this.localTakeOwnership(appName, keyId);
    }

    @Override
    public void removeSession(String appName, Object keyId) {
        if (this.getAppMap(appName).remove(keyId) != null) {
            Object[] args = new Object[]{appName, keyId};
            try {
                this.partition.callMethodOnCluster(this.sessionStateIdentifier, "_removeSession", args, (Class[])REMOVE_SESSION_TYPES, true);
            }
            catch (Exception e) {
                this.log.error((Object)"operation failed", (Throwable)e);
            }
        }
    }

    public void _removeSession(String appName, Object keyId) {
        PackagedSession session = (PackagedSession)this.getAppMap(appName).remove(keyId);
        if (session != null && session.getOwner().equals(this.myNodeName)) {
            this.ownedObjectExternallyModified(appName, keyId, session, session);
        }
    }

    @Override
    public void subscribe(String appName, HASessionState.HASessionStateListener listener) {
        CopyOnWriteArraySet<HASessionState.HASessionStateListener> set = new CopyOnWriteArraySet<HASessionState.HASessionStateListener>();
        CopyOnWriteArraySet<HASessionState.HASessionStateListener> existing = this.appListenerMap.putIfAbsent(appName, set);
        (existing != null ? existing : set).add(listener);
    }

    @Override
    public void unsubscribe(String appName, HASessionState.HASessionStateListener listener) {
        Set listeners = (Set)this.appListenerMap.get(appName);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void ownedObjectExternallyModified(String appName, Object key, PackagedSession oldSession, PackagedSession newSession) {
        Set listeners = (Set)this.appListenerMap.get(appName);
        if (listeners != null) {
            for (HASessionState.HASessionStateListener listener : listeners) {
                try {
                    listener.sessionExternallyModified(newSession);
                }
                catch (Throwable e) {
                    this.log.debug((Object)e);
                }
            }
        }
    }

    @Override
    public HAPartition getCurrentHAPartition() {
        return this.partition;
    }
}

