/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.ha.singleton.HASingletonProfileActivator;
import org.jboss.ha.singleton.HASingletonProfileManagerMBean;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicSubProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.HotDeploymentProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.ImmutableProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.AbstractProfileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HASingletonProfileManager
extends HASingletonProfileActivator
implements HASingletonProfileManagerMBean {
    private AbstractProfileFactory profileFactory;
    private List<URI> uriList = new CopyOnWriteArrayList<URI>();

    public AbstractProfileFactory getProfileFactory() {
        return this.profileFactory;
    }

    public void setProfileFactory(AbstractProfileFactory profileFactory) {
        this.profileFactory = profileFactory;
    }

    @Override
    public void setURIList(List<URI> list) throws IOException {
        if (list == null) {
            throw new NullPointerException("list argument cannot be null");
        }
        this.uriList.clear();
        for (int n = 0; n < list.size(); ++n) {
            URI uri = list.get(n);
            if (uri == null) {
                throw new IllegalArgumentException("list element[" + n + "] is null");
            }
            if (!this.uriList.add(uri)) continue;
            this.log.debug((Object)("Added URI: " + uri));
        }
        this.log.debug((Object)("URI list: " + this.uriList));
    }

    @Override
    public List<URI> getURIList() {
        return new ArrayList<URI>(this.uriList);
    }

    public void start() throws Exception {
        if (this.profileFactory == null) {
            throw new IllegalStateException("Must configure profileFactory");
        }
        if (this.getProfileService() == null) {
            throw new IllegalStateException("Must configure profileService");
        }
        URI[] rootURIs = this.uriList.toArray(new URI[this.uriList.size()]);
        String[] rootSubProfiles = new String[]{};
        ProfileMetaData metadata = this.createProfileMetaData(true, rootURIs, rootSubProfiles);
        Profile profile = this.profileFactory.createProfile(this.getProfileKey(), metadata);
        this.getProfileService().registerProfile(profile);
    }

    public void stop() throws Exception {
        ProfileService profSvc = this.getProfileService();
        ProfileKey profKey = this.getProfileKey();
        if (profSvc != null && profKey != null) {
            try {
                if (profSvc.getActiveProfileKeys().contains(profKey)) {
                    this.releaseProfile();
                }
                profSvc.unregisterProfile(profKey);
            }
            catch (NoSuchProfileException e) {
                this.log.warn((Object)("Could not unregister unknown profile " + profKey));
            }
        }
    }

    private ProfileMetaData createProfileMetaData(boolean hotDeployment, URI[] uris, String[] subProfiles) {
        BasicProfileMetaData metaData = new BasicProfileMetaData();
        metaData.setDomain(this.getProfileDomain());
        metaData.setServer(this.getProfileServer());
        metaData.setName(this.getProfileName());
        ProfileSourceMetaData source = this.createSource(uris, hotDeployment);
        metaData.setSource(source);
        ArrayList<BasicSubProfileMetaData> profileList = new ArrayList<BasicSubProfileMetaData>();
        for (String subProfile : subProfiles) {
            BasicSubProfileMetaData md = new BasicSubProfileMetaData();
            md.setName(subProfile);
            profileList.add(md);
        }
        metaData.setSubprofiles(profileList);
        return metaData;
    }

    protected ProfileSourceMetaData createSource(URI[] uris, boolean hotDeployment) {
        Object source = null;
        source = hotDeployment ? new HotDeploymentProfileSourceMetaData() : new ImmutableProfileSourceMetaData();
        ArrayList<String> sources = new ArrayList<String>();
        for (URI uri : uris) {
            sources.add(uri.toString());
        }
        source.setSources(sources);
        return source;
    }
}

