/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.timestamp;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.timestamp.TimestampDiscrepancy;
import org.jboss.ha.timestamp.TimestampDiscrepancyObserver;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.util.threadpool.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampDiscrepancyService
implements KernelControllerContextAware {
    private static final Logger log = Logger.getLogger(TimestampDiscrepancyService.class);
    private static final Class<?>[] PUSH_DISCREPANCY_MAP_TYPES = new Class[]{RemoteDiscrepancies.class};
    private static final Class<?>[] NULL_TYPES = new Class[0];
    private static final Object[] NULL_ARGS = new Object[0];
    private String serviceHAName;
    private final RpcHandler rpcTarget = new RpcHandler();
    private final DRMListener drmListener = new DRMListener();
    private final TreeMap<Server, TimestampDiscrepancy> discrepancies = new TreeMap();
    private final TreeSet<Server> liveServers = new TreeSet();
    private final Map<String, ClusterNode> nodesByName = new ConcurrentHashMap<String, ClusterNode>();
    private int maxDeadServers = 100;
    private long minDeadServerTime = 604800000L;
    private HAPartition partition;
    private long lastStatusCheck;
    private long minStatusCheckFrequency = 108000000L;
    private volatile boolean statusCheckRequired = true;
    private long lastPurge;
    private long minPurgeFrequency = 3600000L;
    private final List<TimestampDiscrepancyObserver> observers = new CopyOnWriteArrayList<TimestampDiscrepancyObserver>();
    private boolean coordinator;
    private ThreadPool threadPool;
    private final Map<ClusterNode, Map<Server, TimestampDiscrepancy>> unresolvedRemoteDependencies = new HashMap<ClusterNode, Map<Server, TimestampDiscrepancy>>();
    private boolean deadMembersKnown = false;

    public HAPartition getPartition() {
        return this.partition;
    }

    public void setPartition(HAPartition partition) {
        this.partition = partition;
    }

    public String getServiceHAName() {
        return this.serviceHAName;
    }

    public void setServiceHAName(String serviceHAName) {
        this.serviceHAName = serviceHAName;
    }

    public int getMaxDeadServers() {
        return this.maxDeadServers;
    }

    public void setMaxDeadServers(int maxDeadServers) {
        this.maxDeadServers = maxDeadServers;
    }

    public long getMinDeadServerTime() {
        return this.minDeadServerTime;
    }

    public void setMinDeadServerTime(long minDeadServerTime) {
        this.minDeadServerTime = minDeadServerTime;
    }

    public long getMinStatusCheckFrequency() {
        return this.minStatusCheckFrequency;
    }

    public void setMinStatusCheckFrequency(long minStatusCheckFrequency) {
        this.minStatusCheckFrequency = minStatusCheckFrequency;
    }

    public long getMinPurgeFrequency() {
        return this.minPurgeFrequency;
    }

    public void setMinPurgeFrequency(long minPurgeFrequency) {
        this.minPurgeFrequency = minPurgeFrequency;
    }

    public long getLastStatusCheck() {
        return this.lastStatusCheck;
    }

    public boolean isStatusCheckRequired() {
        return this.statusCheckRequired;
    }

    public long getLastPurge() {
        return this.lastPurge;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ClusterNode, TimestampDiscrepancy> getTimestampDiscrepancies(boolean allowStatusCheck) {
        if (allowStatusCheck) {
            this.statusCheck();
        }
        this.purgeDeadEntries();
        TreeMap<Server, TimestampDiscrepancy> treeMap = this.discrepancies;
        synchronized (treeMap) {
            HashMap<ClusterNode, TimestampDiscrepancy> result = new HashMap<ClusterNode, TimestampDiscrepancy>();
            for (Map.Entry<Server, TimestampDiscrepancy> entry : this.discrepancies.entrySet()) {
                result.put(entry.getKey().getNode(), entry.getValue());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimestampDiscrepancy getTimestampDiscrepancy(ClusterNode node, boolean allowStatusCheck) {
        if (allowStatusCheck) {
            this.statusCheck();
        }
        this.purgeDeadEntries();
        TreeMap<Server, TimestampDiscrepancy> treeMap = this.discrepancies;
        synchronized (treeMap) {
            return this.discrepancies.get(new Server(node));
        }
    }

    public TimestampDiscrepancy getTimestampDiscrepancy(String nodeName, boolean allowStatusCheck) {
        ClusterNode node = this.nodesByName.get(nodeName);
        return node == null ? null : this.getTimestampDiscrepancy(node, allowStatusCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServerActive(ClusterNode node) {
        TreeSet<Server> treeSet = this.liveServers;
        synchronized (treeSet) {
            return this.liveServers.contains(new Server(node));
        }
    }

    public void start() throws Exception {
        this.partition.registerRPCHandler(this.getServiceHAName(), (Object)this.rpcTarget);
        DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
        drm.add(this.getServiceHAName(), (Serializable)this.partition.getClusterNode());
        this.coordinator = drm.isMasterReplica(this.getServiceHAName());
        drm.registerListener(this.getServiceHAName(), (DistributedReplicantManager.ReplicantListener)this.drmListener);
        this.statusCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
        drm.unregisterListener(this.getServiceHAName(), (DistributedReplicantManager.ReplicantListener)this.drmListener);
        drm.remove(this.getServiceHAName());
        this.coordinator = false;
        this.partition.unregisterRPCHandler(this.getServiceHAName(), (Object)this.rpcTarget);
        Object object = this.liveServers;
        synchronized (object) {
            this.liveServers.clear();
        }
        object = this.unresolvedRemoteDependencies;
        synchronized (object) {
            this.unresolvedRemoteDependencies.clear();
        }
    }

    public void registerObserver(TimestampDiscrepancyObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    public void unregisterObserver(TimestampDiscrepancyObserver observer) {
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        if (context != null && this.serviceHAName == null) {
            this.setServiceHAName(context.getName().toString());
        }
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void statusCheck() {
        if (this.statusCheckRequired || System.currentTimeMillis() - this.lastStatusCheck > this.minStatusCheckFrequency) {
            try {
                long requestSent = System.currentTimeMillis();
                ArrayList rsps = this.partition.callMethodOnCluster(this.getServiceHAName(), "getLocalTimestamp", NULL_ARGS, (Class[])NULL_TYPES, true);
                long responseReceived = System.currentTimeMillis();
                long mcastTime = responseReceived - requestSent;
                HashMap<ClusterNode, TimestampDiscrepancy> rspBySender = new HashMap<ClusterNode, TimestampDiscrepancy>();
                if (rsps != null) {
                    for (Object rsp : rsps) {
                        if (rsp instanceof TimestampResponse) {
                            TimestampResponse tr = (TimestampResponse)rsp;
                            rspBySender.put(tr.getResponder(), new TimestampDiscrepancy(tr.getTimestamp(), requestSent, responseReceived));
                            continue;
                        }
                        if (rsp == null) continue;
                        log.warn((Object)("Unknown status check response " + rsp));
                    }
                }
                if (mcastTime > 250L) {
                    List nodes = this.partition.getDistributedReplicantManager().lookupReplicantsNodes(this.getServiceHAName());
                    for (ClusterNode node : nodes) {
                        if (node.equals(this.partition.getClusterNode())) continue;
                        try {
                            long singleRequestSent = System.currentTimeMillis();
                            Object rsp = this.partition.callMethodOnNode(this.getServiceHAName(), "getLocalTimestamp", NULL_ARGS, (Class[])NULL_TYPES, mcastTime, node);
                            long singleResponseReceived = System.currentTimeMillis();
                            long elapsed = singleResponseReceived - singleRequestSent;
                            if (elapsed >= mcastTime) continue;
                            if (rsp instanceof TimestampResponse) {
                                TimestampResponse tr = (TimestampResponse)rsp;
                                rspBySender.put(tr.getResponder(), new TimestampDiscrepancy(tr.getTimestamp(), singleRequestSent, singleResponseReceived));
                                continue;
                            }
                            if (rsp == null) continue;
                            log.warn((Object)("Unknown status check response " + rsp));
                        }
                        catch (Throwable e) {
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                            log.error((Object)("Caught exception requesting timestamp from node " + node), e);
                        }
                    }
                }
                TreeMap<Server, TimestampDiscrepancy> treeMap = this.discrepancies;
                synchronized (treeMap) {
                    TreeSet<Server> treeSet = this.liveServers;
                    synchronized (treeSet) {
                        for (Map.Entry entry : rspBySender.entrySet()) {
                            Server s = new Server((ClusterNode)entry.getKey());
                            TimestampDiscrepancy latest = (TimestampDiscrepancy)entry.getValue();
                            TimestampDiscrepancy existing = this.discrepancies.get(s);
                            if (existing == null || latest.getDiscrepancyRange() <= existing.getDiscrepancyRange() || !this.liveServers.contains(s)) {
                                this.updateTimestampDiscrepancy(s, latest, true);
                                continue;
                            }
                            if (existing.getMinDiscrepancy() < latest.getMinDiscrepancy() || existing.getMaxDiscrepancy() > latest.getMaxDiscrepancy()) {
                                this.updateTimestampDiscrepancy(s, latest, true);
                                continue;
                            }
                            this.updateTimestampDiscrepancy(s, existing, true);
                        }
                    }
                }
                this.statusCheckRequired = false;
                this.lastStatusCheck = System.currentTimeMillis();
            }
            catch (Exception e) {
                log.error((Object)"Caught exception in status check", (Throwable)e);
            }
        }
        this.getDeadMembersFromCoordinator();
    }

    private void getDeadMembersFromCoordinator() {
        if (!this.deadMembersKnown) {
            try {
                ClusterNode coord;
                DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
                List nodes = drm.lookupReplicantsNodes(this.getServiceHAName());
                ClusterNode clusterNode = coord = nodes != null && nodes.size() > 0 ? (ClusterNode)nodes.get(0) : null;
                if (coord != null && !coord.equals(this.partition.getClusterNode())) {
                    Object rsp = this.partition.callMethodOnNode(this.getServiceHAName(), "getDiscrepancies", NULL_ARGS, (Class[])NULL_TYPES, 60000L, coord);
                    if (rsp instanceof RemoteDiscrepancies) {
                        this.handleRemoteDiscrepancies((RemoteDiscrepancies)rsp);
                        this.deadMembersKnown = true;
                    } else {
                        log.error((Object)("No valid response from coordinator: " + rsp));
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                log.error((Object)"Caught exception pulling dead member records from coordinator", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicantsChanged(List<ClusterNode> newReplicants, boolean merge) {
        Object replicant2;
        boolean wasCoordinator = this.coordinator;
        HashSet<Server> newServers = new HashSet<Server>();
        for (Object replicant2 : newReplicants) {
            newServers.add(new Server((ClusterNode)replicant2));
        }
        boolean hasAdds = false;
        replicant2 = this.liveServers;
        synchronized (replicant2) {
            for (Server s : newServers) {
                if (this.liveServers.contains(s)) continue;
                this.liveServers.add(s);
                hasAdds = true;
            }
            if (this.liveServers.size() != newServers.size()) {
                Iterator<Server> it = this.liveServers.iterator();
                while (it.hasNext()) {
                    Server s;
                    s = it.next();
                    if (newServers.contains(s)) continue;
                    it.remove();
                }
            }
        }
        if (hasAdds) {
            this.statusCheckRequired = true;
        }
        DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
        this.coordinator = drm.isMasterReplica(this.getServiceHAName());
        if (wasCoordinator && !this.coordinator) {
            Runnable r = this.getDiscrepancyPushTask();
            this.executeRunnable(r, this.getServiceHAName() + "-DiscrepancyMapPusher");
        } else if (this.coordinator) {
            final Runnable push = this.getDiscrepancyPushTask();
            Runnable r = new Runnable(){

                public void run() {
                    TimestampDiscrepancyService.this.statusCheck();
                    push.run();
                }
            };
            this.executeRunnable(r, this.getServiceHAName() + "-AsyncStatusCheck");
        }
    }

    private void executeRunnable(final Runnable r, String threadName) {
        if (this.threadPool != null) {
            this.threadPool.run(r);
        } else {
            final Thread t = new Thread(r, threadName);
            t.setDaemon(true);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    t.setContextClassLoader(r.getClass().getClassLoader());
                    return null;
                }
            });
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void purgeDeadEntries() {
        if (System.currentTimeMillis() - this.lastPurge > this.minPurgeFrequency) {
            TreeMap<Server, TimestampDiscrepancy> treeMap = this.discrepancies;
            synchronized (treeMap) {
                TreeSet<Server> treeSet = this.liveServers;
                synchronized (treeSet) {
                    this.lastPurge = System.currentTimeMillis();
                    Server oldestLive = this.liveServers.isEmpty() ? null : this.liveServers.first();
                    Set<Server> deadServers = oldestLive == null ? this.discrepancies.keySet() : this.discrepancies.headMap(oldestLive).keySet();
                    int excess = deadServers.size() - this.maxDeadServers;
                    if (excess > 0) {
                        HashSet<Server> toClean = new HashSet<Server>();
                        for (Server server : deadServers) {
                            long min = System.currentTimeMillis() - this.minDeadServerTime;
                            if (excess <= 0 || server.getTimestampChecked() >= min) break;
                            for (TimestampDiscrepancyObserver observer : this.observers) {
                                if (observer.canRemoveDeadEntry(server.getNode(), server.getTimestampChecked())) continue;
                            }
                            toClean.add(server);
                            --excess;
                        }
                        for (Server toRemove : toClean) {
                            this.discrepancies.remove(toRemove);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimestampDiscrepancy(Server server, TimestampDiscrepancy discrepancy, boolean live) {
        this.discrepancies.put(server, discrepancy);
        this.nodesByName.put(server.getNode().getName(), server.getNode());
        if (live) {
            this.liveServers.add(server);
        }
        Map<ClusterNode, Map<Server, TimestampDiscrepancy>> map = this.unresolvedRemoteDependencies;
        synchronized (map) {
            Map<Server, TimestampDiscrepancy> unresolved = this.unresolvedRemoteDependencies.remove(server.getNode());
            if (unresolved != null) {
                this.convertRemoteDiscrepanciesToLocalTime(unresolved, discrepancy);
            }
        }
        for (TimestampDiscrepancyObserver observer : this.observers) {
            observer.timestampDiscrepancyChanged(server.getNode(), discrepancy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoteDiscrepancies(RemoteDiscrepancies remote) {
        ClusterNode sender = remote.getSender();
        Map<Server, TimestampDiscrepancy> remoteDiscrepancies = remote.getDiscrepancies();
        TreeMap<Server, TimestampDiscrepancy> treeMap = this.discrepancies;
        synchronized (treeMap) {
            TimestampDiscrepancy senderDiscrepancy = this.discrepancies.get(new Server(sender));
            if (senderDiscrepancy == null) {
                Map<ClusterNode, Map<Server, TimestampDiscrepancy>> map = this.unresolvedRemoteDependencies;
                synchronized (map) {
                    this.unresolvedRemoteDependencies.put(sender, remoteDiscrepancies);
                }
            } else {
                this.convertRemoteDiscrepanciesToLocalTime(remoteDiscrepancies, senderDiscrepancy);
            }
        }
    }

    private void convertRemoteDiscrepanciesToLocalTime(Map<Server, TimestampDiscrepancy> remoteDiscrepancies, TimestampDiscrepancy senderDiscrepancy) {
        for (Map.Entry<Server, TimestampDiscrepancy> entry : remoteDiscrepancies.entrySet()) {
            Server key = entry.getKey();
            if (this.discrepancies.get(key) != null) continue;
            this.discrepancies.put(new Server(key, senderDiscrepancy), new TimestampDiscrepancy(entry.getValue(), senderDiscrepancy));
            ClusterNode node = key.getNode();
            this.nodesByName.put(node.getName(), node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable getDiscrepancyPushTask() {
        HashMap<Server, TimestampDiscrepancy> map = null;
        TreeMap<Server, TimestampDiscrepancy> treeMap = this.discrepancies;
        synchronized (treeMap) {
            map = new HashMap<Server, TimestampDiscrepancy>(this.discrepancies);
        }
        final RemoteDiscrepancies arg = new RemoteDiscrepancies(this.partition.getClusterNode(), map);
        final HAPartition haPartition = this.partition;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    haPartition.callMethodOnCluster(TimestampDiscrepancyService.this.getServiceHAName(), "pushDiscrepancyMap", new Object[]{arg}, PUSH_DISCREPANCY_MAP_TYPES, true);
                }
                catch (Exception e) {
                    log.error((Object)"Exception pushing Discrepancy map to cluster", (Throwable)e);
                }
            }
        };
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoteDiscrepancies
    implements Serializable {
        private static final long serialVersionUID = -7394430305832099065L;
        private final ClusterNode sender;
        private final Map<Server, TimestampDiscrepancy> discrepancies;

        private RemoteDiscrepancies(ClusterNode sender, Map<Server, TimestampDiscrepancy> discrepancies) {
            if (sender == null) {
                throw new IllegalArgumentException("Null sender");
            }
            if (discrepancies == null) {
                throw new IllegalArgumentException("Null discrepancies");
            }
            this.sender = sender;
            this.discrepancies = discrepancies;
        }

        public ClusterNode getSender() {
            return this.sender;
        }

        public Map<Server, TimestampDiscrepancy> getDiscrepancies() {
            return this.discrepancies;
        }
    }

    public static class TimestampResponse
    implements Serializable {
        private static final long serialVersionUID = -9171752596968923020L;
        private final ClusterNode responder;
        private final long timestamp = System.currentTimeMillis();

        private TimestampResponse(ClusterNode responder) {
            if (responder == null) {
                throw new IllegalArgumentException("Null responder");
            }
            this.responder = responder;
        }

        public ClusterNode getResponder() {
            return this.responder;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Server
    implements Serializable,
    Comparable<Server> {
        private static final long serialVersionUID = 4477441836405966100L;
        private final ClusterNode node;
        private final long timestampChecked;

        private Server(ClusterNode node) {
            if (node == null) {
                throw new IllegalArgumentException("Null node");
            }
            this.node = node;
            this.timestampChecked = System.currentTimeMillis();
        }

        private Server(Server base, TimestampDiscrepancy offset) {
            this.node = base.node;
            this.timestampChecked = offset.getMaxLocalTimestamp(base.timestampChecked);
        }

        public ClusterNode getNode() {
            return this.node;
        }

        public long getTimestampChecked() {
            return this.timestampChecked;
        }

        @Override
        public int compareTo(Server o) {
            if (this.node.equals(o.node)) {
                return 0;
            }
            return (int)(this.timestampChecked - o.timestampChecked);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Server) {
                return this.node.equals(((Server)obj).node);
            }
            return false;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("{node=");
            sb.append(this.node);
            sb.append('}');
            return sb.toString();
        }
    }

    private class DRMListener
    implements DistributedReplicantManager.ReplicantListener {
        private DRMListener() {
        }

        public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
            TimestampDiscrepancyService.this.replicantsChanged(newReplicants, merge);
        }
    }

    public class RpcHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteDiscrepancies getDiscrepancies() {
            HashMap result = null;
            TreeMap treeMap = TimestampDiscrepancyService.this.discrepancies;
            synchronized (treeMap) {
                result = new HashMap(TimestampDiscrepancyService.this.discrepancies);
            }
            return new RemoteDiscrepancies(TimestampDiscrepancyService.this.partition.getClusterNode(), result);
        }

        public TimestampResponse getLocalTimestamp() {
            return new TimestampResponse(TimestampDiscrepancyService.this.partition.getClusterNode());
        }

        public void pushDiscrepancyMap(RemoteDiscrepancies remote) {
            TimestampDiscrepancyService.this.handleRemoteDiscrepancies(remote);
        }
    }
}

