/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.resource.metadata.mcf;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.w3c.dom.Element;

/**
 * A ManagedConnectionEmptyContentAdapter.
 * 
 * @author <a href="weston.price@jboss.org">Weston Price</a>
 * @version $Revision: 1.1 $
 */
public class ManagedConnectionEmptyContentAdapter extends XmlAdapter<Object, Boolean>
{
   
   @Override
   public Boolean unmarshal(Object obj) throws Exception
   {      
      Element e = (Element)obj;
      Boolean results = Boolean.FALSE;
      
      
      if (e.getNodeName().equals("track-connection-by-tx") || e.getNodeName().equals("no-tx-separate-pools")
            || e.getNodeName().equals("local-transaction") || e.getNodeName().equals("use-strict-min") || e.getNodeName().equals("xa-transaction"))
      {
         results = Boolean.TRUE;

      }               
      
      return results;
   }

   @Override
   public Object marshal(Boolean b) throws Exception
   {
      return null;
   }
}
