/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.resource.deployers.management;

import java.io.Serializable;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.factory.AbstractInstanceClassFactory;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.resource.metadata.mcf.TxConnectionFactoryDeploymentMetaData;

/**
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 69689 $
 */
public class TxInstanceClassFactory
   extends AbstractInstanceClassFactory<TxConnectionFactoryDeploymentMetaData>
{
   public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property,
         TxConnectionFactoryDeploymentMetaData attachment)
   {
      MetaValue value = null;
      if("config-property".equals(property.getName()))
      {
         value = InstanceClassFactoryUtils.getConfigPropertyValue(beanInfo, property, attachment);
      }
      else
      {
         value = super.getValue(beanInfo, property, attachment);
      }
      return value;
   }

   @Override
   protected Object unwrapValue(BeanInfo beanInfo, ManagedProperty property,
         MetaValue value)
   {
      if((value instanceof MapCompositeValueSupport) == false)
      {
         return super.unwrapValue(beanInfo, property, value);
      }

      Object unwrapValue = null;
      if("config-property".equals(property.getName()))
      {
         unwrapValue = InstanceClassFactoryUtils.unwrapConfigPropertyValue(beanInfo,
               property, value, getMetaValueFactory());
      }
      return unwrapValue;
   }
}
