/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.mail.inflow;

import java.util.Iterator;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import org.jboss.resource.adapter.mail.inflow.IMAPMailFolder;
import org.jboss.resource.adapter.mail.inflow.IMAPsMailFolder;
import org.jboss.resource.adapter.mail.inflow.MailActivationSpec;
import org.jboss.resource.adapter.mail.inflow.POP3MailFolder;
import org.jboss.resource.adapter.mail.inflow.POP3sMailFolder;

public abstract class MailFolder
implements Iterator {
    private Session session;
    private Store store;
    private Folder folder;
    private String mailServer;
    private String folderName;
    private String userName;
    private String password;
    private int port;
    private boolean debug;
    private boolean starttls;
    private Properties sessionProps;
    private Message[] msgs = new Message[0];
    private int messagePosition;

    public MailFolder(MailActivationSpec spec) {
        this.mailServer = spec.getMailServer();
        this.folderName = spec.getMailFolder();
        this.userName = spec.getUserName();
        this.password = spec.getPassword();
        this.debug = spec.isDebug();
        this.starttls = spec.isStarttls();
        this.port = spec.getPort();
        this.sessionProps = new Properties();
        this.sessionProps.setProperty("mail.transport.protocol", "smtp");
        this.sessionProps.setProperty("mail.smtp.host", this.mailServer);
        this.sessionProps.setProperty("mail.debug", this.debug + "");
        this.sessionProps.setProperty("mail.imap.starttls.enable", this.starttls + "");
    }

    public void open() throws Exception {
        this.session = Session.getInstance((Properties)this.sessionProps);
        this.session.setDebug(this.debug);
        this.store = this.openStore(this.session);
        if (this.port == 0) {
            this.store.connect(this.mailServer, this.userName, this.password);
        } else {
            this.store.connect(this.mailServer, this.port, this.userName, this.password);
        }
        this.folder = this.store.getFolder(this.folderName);
        if (this.folder == null || !this.folder.exists()) {
            MessagingException e = new MessagingException("Failed to find folder: " + this.folderName);
            throw e;
        }
        this.folder.open(2);
        this.msgs = this.getMessages(this.folder);
    }

    protected abstract Store openStore(Session var1) throws NoSuchProviderException;

    protected abstract void closeStore(boolean var1, Store var2, Folder var3) throws MessagingException;

    protected abstract Message[] getMessages(Folder var1) throws MessagingException;

    protected abstract void markMessageSeen(Message var1) throws MessagingException;

    public void close() throws MessagingException {
        this.close(true);
    }

    public boolean hasNext() {
        return this.messagePosition < this.msgs.length;
    }

    public Object next() {
        try {
            Message m = this.msgs[this.messagePosition++];
            this.markMessageSeen(m);
            return m;
        }
        catch (MessagingException e) {
            this.close(false);
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void close(boolean checkSuccessful) {
        try {
            this.closeStore(checkSuccessful, this.store, this.folder);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Error closing mail store", e);
        }
    }

    public static MailFolder getInstance(MailActivationSpec mailActivationSpec) {
        if ("pop3".equals(mailActivationSpec.getStoreProtocol())) {
            return new POP3MailFolder(mailActivationSpec);
        }
        if ("imap".equals(mailActivationSpec.getStoreProtocol())) {
            return new IMAPMailFolder(mailActivationSpec);
        }
        if ("pop3s".equals(mailActivationSpec.getStoreProtocol())) {
            return new POP3sMailFolder(mailActivationSpec);
        }
        if ("imaps".equals(mailActivationSpec.getStoreProtocol())) {
            return new IMAPsMailFolder(mailActivationSpec);
        }
        return null;
    }
}

