/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.resource.metadata.repository;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import org.jboss.resource.metadata.ConnectorMetaData;

/**
 * A JCAConnectorMetaDataEntry.
 * 
 * @author <a href="weston.price@jboss.org">Weston Price</a>
 * @version $Revision: 1.1 $
 */
public class JCAConnectorMetaDataEntry implements Serializable
{   
   static final long serialVersionUID = 2115245854346888893L;
   private ConnectorMetaData md;
   private List<JCADeploymentMetaDataEntry> deployments = new CopyOnWriteArrayList<JCADeploymentMetaDataEntry>();
   
   public ConnectorMetaData getConnectorMetaData()
   {
      return this.md;      
   }
   
   public void setConnectorMetaData(ConnectorMetaData md)
   {
      this.md = md;      
   }

   public List<JCADeploymentMetaDataEntry> getDeployments()
   {
      return Collections.unmodifiableList(deployments);      
   }
   
   public void addDeployment(JCADeploymentType type, Object deployment)
   {
      JCADeploymentMetaDataEntry deploymentEntry = new JCADeploymentMetaDataEntry();
      deploymentEntry.setDeploymentType(type);
      deployments.add(deploymentEntry);
      
   }

}
