/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.resource.deployers.management;

import java.util.ArrayList;
import java.util.List;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.resource.metadata.mcf.ApplicationManagedSecurityMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
import org.jboss.resource.metadata.mcf.SecurityDeploymentType;
import org.jboss.resource.metadata.mcf.SecurityDomainApplicationManagedMetaData;
import org.jboss.resource.metadata.mcf.SecurityDomainMetaData;
import org.jboss.resource.metadata.mcf.SecurityMetaData;

/**
 * property to meta value conversion for common properties
 * @author Scott.Stark@jboss.org
 * @version $Revision: 82069 $
 */
public class InstanceClassFactoryUtils
{
   /**
    * Transform the ManagedConnectionFactoryProperties into a
    * MapCompositeValueSupport value.
    * 
    * @param <T>
    * @param beanInfo
    * @param property
    * @param attachment
    * @return
    */
   static <T extends ManagedConnectionFactoryDeploymentMetaData>
      MetaValue getConfigPropertyValue(BeanInfo beanInfo, ManagedProperty property, T attachment)
   {
      MapCompositeValueSupport map = new MapCompositeValueSupport(SimpleMetaType.STRING);
      List<ManagedConnectionFactoryPropertyMetaData> list = attachment.getManagedConnectionFactoryProperties();
      if(list != null)
      {
         for(ManagedConnectionFactoryPropertyMetaData prop : list)
         {
            String name = prop.getName();               
            MetaValue svalue = SimpleValueSupport.wrap(prop.getValue());
            map.put(name, svalue);
            MetaValue stype = SimpleValueSupport.wrap(prop.getValue());
            map.put(name+".type", stype);
         }
      }
      return map;
   }
   /**
    * 
    * @param beanInfo
    * @param property
    * @param value
    * @param metaValueFactory
    * @return
    */
   static Object unwrapConfigPropertyValue(BeanInfo beanInfo, ManagedProperty property,
         MetaValue value, MetaValueFactory metaValueFactory)
   {
      MapCompositeValueSupport mapValue = (MapCompositeValueSupport) value;
      List<ManagedConnectionFactoryPropertyMetaData> list = new ArrayList<ManagedConnectionFactoryPropertyMetaData>();
      for(String name : mapValue.getMetaType().keySet())
      {
         ManagedConnectionFactoryPropertyMetaData prop = new ManagedConnectionFactoryPropertyMetaData();
         prop.setName(name);
         String svalue = (String) metaValueFactory.unwrap(mapValue.get(name));
         prop.setValue(svalue);
         String nameType = name+".type";
         MetaValue typeValue = mapValue.get(nameType);
         if(typeValue != null)
         {
            String type = (String) metaValueFactory.unwrap(typeValue);
            prop.setType(type);
         }
         list.add(prop);
      }
      return list;
   }

   /**
    * Handle the mapping of SecurityMetaData managed object values
    * @param beanInfo
    * @param property
    * @param attachment
    * @param value
    */
   static void setValue(ManagedConnectionFactoryDeploymentMetaData attachment, ManagedObject mo)
   {
      // Create the correct type of SecurityMetaData
      ManagedProperty type = mo.getProperty("securityDeploymentType");
      ManagedProperty domain = mo.getProperty("domain");
      String domainName = ((SimpleValue) domain.getValue()).getValue().toString();
      EnumValue typeValue = (EnumValue) type.getValue();
      String typeString = typeValue.getValue();
      SecurityDeploymentType stype = SecurityDeploymentType.valueOf(typeString);
      SecurityMetaData domainMD = null;
      switch(stype)
      {
         case APPLICATION:
            domainMD = new ApplicationManagedSecurityMetaData();
            break;
         case DOMAIN:
            domainMD = new SecurityDomainMetaData();
            break;
         case DOMAIN_AND_APPLICATION:
            domainMD = new SecurityDomainApplicationManagedMetaData();
            break;
         default:
         case NONE:
            domainMD = new SecurityMetaData();
            break;
      }
      domainMD.setDomain(domainName);
      attachment.setSecurityMetaData(domainMD);
   }
}
