/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.metadata.mcf;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementPropertyFactory;
import org.jboss.resource.deployers.management.ConnectionFactoryProperty;
import org.jboss.resource.deployers.management.XAConnectionFactoryProperty;
import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryTransactionSupportMetaData;
import org.jboss.resource.metadata.mcf.XAConnectionPropertyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="xa-datasource")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ManagementObject(componentType=@ManagementComponent(type="DataSource", subtype="XA"))
public class XADataSourceDeploymentMetaData
extends DataSourceDeploymentMetaData {
    private static final long serialVersionUID = -6919645811610960978L;
    private static final String RAR_NAME = "jboss-xa-jdbc.rar";
    @XmlElement(name="xa-datasource-class")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String xaDataSourceClass;
    @XmlElement(name="xa-datasource-property")
    private List<XAConnectionPropertyMetaData> xaDataSourceProperties = new ArrayList<XAConnectionPropertyMetaData>();
    @XmlElement(name="url-property")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String urlProperty;
    @XmlElement(name="xa-resource-timeout")
    private int xaResourceTimeout;

    public XADataSourceDeploymentMetaData() {
        this.setRarName(RAR_NAME);
        this.setTransactionSupportMetaData(ManagedConnectionFactoryTransactionSupportMetaData.XA);
    }

    @ManagementProperty(name="xa-datasource-class", description="The XADataSource class", mandatory=true, includeInTemplate=true)
    public String getXaDataSourceClass() {
        return this.xaDataSourceClass;
    }

    public void setXaDataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    @ManagementProperty(name="url-property", description="The url-property", includeInTemplate=true)
    public String getURLProperty() {
        return this.urlProperty;
    }

    public void setURLProperty(String urlProperty) {
        this.urlProperty = urlProperty;
    }

    @ManagementProperty(name="xa-resource-timeout", description="The XAResource timeout", includeInTemplate=true)
    public int getXaResourceTimeout() {
        return this.xaResourceTimeout;
    }

    public void setXaResourceTimeout(int xaResourceTimeout) {
        this.xaResourceTimeout = xaResourceTimeout;
    }

    @ManagementProperty(name="xa-datasource-properties", description="The xa datasource properties", managed=true, includeInTemplate=true)
    @ManagementPropertyFactory(value=XAConnectionFactoryProperty.class)
    public List<XAConnectionPropertyMetaData> getXADataSourceProperties() {
        return this.xaDataSourceProperties;
    }

    public void setXADataSourceProperties(List<XAConnectionPropertyMetaData> xaDataSourceProperties) {
        this.xaDataSourceProperties = xaDataSourceProperties;
    }

    @Override
    @ManagementProperty(name="config-property", description="The connection factory property info", managed=true, readOnly=true)
    @ManagementPropertyFactory(value=ConnectionFactoryProperty.class)
    public List<ManagedConnectionFactoryPropertyMetaData> getManagedConnectionFactoryProperties() {
        List<ManagedConnectionFactoryPropertyMetaData> properties = super.getManagedConnectionFactoryProperties();
        ManagedConnectionFactoryPropertyMetaData property = null;
        if (this.getXaDataSourceClass() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("XADataSourceClass");
            property.setValue(this.getXaDataSourceClass());
            properties.add(property);
        }
        List<XAConnectionPropertyMetaData> dsProps = this.getXADataSourceProperties();
        StringBuffer dsBuff = new StringBuffer();
        if (dsProps != null) {
            for (XAConnectionPropertyMetaData data : dsProps) {
                dsBuff.append(data.getName() + "=" + data.getValue() + "\n");
            }
        }
        property = new ManagedConnectionFactoryPropertyMetaData();
        property.setName("XADataSourceProperties");
        property.setValue(dsBuff.toString());
        properties.add(property);
        if (this.getURLProperty() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("URLProperty");
            property.setValue(this.getURLProperty());
            properties.add(property);
        }
        return properties;
    }
}

