/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.statistic.pool;

import java.util.Collection;
import org.jboss.resource.statistic.JBossStatistics;
import org.jboss.resource.statistic.formatter.StatisticsFormatter;
import org.jboss.resource.statistic.pool.JBossSubPoolStatistics;
import org.jboss.resource.statistic.pool.ManagedConnectionPoolStatistics;

public class JBossDefaultSubPoolStatisticFormatter
implements StatisticsFormatter {
    private static final String POOL_SEPERATOR = "------------------------------------------------------";

    public Object formatSubPoolStatistics(Collection subPoolStatistics) {
        StringBuffer statBuff = JBossDefaultSubPoolStatisticFormatter.formatHeader(subPoolStatistics.size());
        for (JBossSubPoolStatistics stat : subPoolStatistics) {
            statBuff.append(stat);
            statBuff.append("\n");
            statBuff.append(POOL_SEPERATOR);
            statBuff.append("\n\n");
        }
        return statBuff.toString();
    }

    public Object formatSubPoolStatistics(ManagedConnectionPoolStatistics stats) {
        return this.formatSubPoolStatistics(stats.getSubPools());
    }

    private static StringBuffer formatHeader(int count) {
        StringBuffer headerBuff = new StringBuffer();
        headerBuff.append("Sub Pool Statistics: \n");
        headerBuff.append("Sub Pool Count: " + count + "\n");
        headerBuff.append(POOL_SEPERATOR);
        headerBuff.append("\n\n");
        return headerBuff;
    }

    public Object formatStatistics(JBossStatistics stats) {
        if (!(stats instanceof ManagedConnectionPoolStatistics)) {
            throw new IllegalArgumentException("Error: invalid statistics implementaiton for formatter.");
        }
        ManagedConnectionPoolStatistics poolStats = (ManagedConnectionPoolStatistics)stats;
        return this.formatSubPoolStatistics(poolStats);
    }
}

