/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.quartz.inflow;

import java.io.IOException;
import java.io.InputStream;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.quartz.inflow.QuartzActivationSpec;
import org.jboss.resource.adapter.quartz.inflow.QuartzJob;
import org.jboss.resource.adapter.quartz.inflow.StatefulQuartzJob;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzResourceAdapter
implements ResourceAdapter {
    private static Logger log = Logger.getLogger(QuartzResourceAdapter.class);
    private static final ThreadLocal<WorkManager> holder = new ThreadLocal();
    private Scheduler sched;
    public static final String QUARTZ_PROPERTIES_PATH = "org/jboss/resource/adapter/quartz/inflow/quartz.properties";

    public static WorkManager getConfigTimeWorkManager() {
        return holder.get();
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        log.debug((Object)"Start Quartz scheduler");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream quartzPropsStream = cl.getResourceAsStream(QUARTZ_PROPERTIES_PATH);
        StdSchedulerFactory sf = new StdSchedulerFactory();
        try {
            holder.set(ctx.getWorkManager());
            sf.initialize(quartzPropsStream);
            this.sched = sf.getScheduler();
            this.sched.start();
        }
        catch (SchedulerException e) {
            throw new ResourceAdapterInternalException((Throwable)e);
        }
        finally {
            holder.remove();
            try {
                quartzPropsStream.close();
            }
            catch (IOException e) {
                log.debug((Object)("Unable to close quartz properties file: " + e), (Throwable)e);
            }
        }
    }

    public void stop() {
        log.debug((Object)"Stop Quartz scheduler");
        try {
            this.sched.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        log.debug((Object)("endpointActivation, spec=" + spec));
        QuartzActivationSpec quartzSpec = (QuartzActivationSpec)spec;
        Class<QuartzJob> clazz = QuartzJob.class;
        MessageEndpoint tmpMe = endpointFactory.createEndpoint(null);
        if (tmpMe instanceof StatefulJob) {
            clazz = StatefulQuartzJob.class;
        }
        tmpMe.release();
        try {
            JobDetail jobDetail = new JobDetail(quartzSpec.getJobName(), quartzSpec.getJobGroup(), clazz, true, false, false);
            jobDetail.getJobDataMap().setAllowsTransientData(true);
            jobDetail.getJobDataMap().put((Object)"endpointFactory", (Object)endpointFactory);
            log.debug((Object)("adding job: " + quartzSpec));
            CronTrigger trigger = new CronTrigger(quartzSpec.getTriggerName(), quartzSpec.getTriggerGroup(), quartzSpec.getCronTrigger());
            this.sched.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ResourceException((Throwable)e);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        QuartzActivationSpec quartzSpec = (QuartzActivationSpec)spec;
        try {
            log.debug((Object)("****endpointDeactivation: " + quartzSpec));
            this.sched.deleteJob(quartzSpec.getJobName(), quartzSpec.getJobGroup());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return new XAResource[0];
    }
}

