/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NamingException;
import org.jboss.console.twiddle.command.Command;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.NoSuchCommandException;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.Strings;

public class Twiddle {
    public static final String PROGRAM_NAME = System.getProperty("program.name", "twiddle");
    public static final String CMD_PROPERTIES = "/org/jboss/console/twiddle/commands.properties";
    public static final String DEFAULT_BASEURL = "service:jmx:rmi:///jndi/rmi://";
    public static final String DEFAULT_RMIOBJECTNAME = "/jmxrmi";
    public static final String DEFAULT_JMXSERVICEURL = "service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_PORT = "1090";
    private static final Logger log = Logger.getLogger(Twiddle.class);
    private static Twiddle twiddle = new Twiddle(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    private static String commandName;
    private static String[] commandArgs;
    private static boolean commandHelp;
    private static URL cmdProps;
    private List commandProtoList = new ArrayList();
    private Map commandProtoMap = new HashMap();
    private PrintWriter out;
    private PrintWriter err;
    private String serverURL = this.buildJMXServiceUrl();
    private String hostname;
    private String port;
    private boolean quiet;
    private MBeanServerConnection server;
    JMXConnector jmxc;
    private String username;
    private String password;
    private boolean verbose;

    public Twiddle(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
    }

    private String buildJMXServiceUrl() {
        return DEFAULT_BASEURL + (this.hostname != null ? this.hostname : DEFAULT_HOSTNAME) + ":" + (this.port != null ? this.port : DEFAULT_PORT) + DEFAULT_RMIOBJECTNAME;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.setServerURL(this.buildJMXServiceUrl());
    }

    public void setPort(String port) {
        this.port = port;
        this.setServerURL(this.buildJMXServiceUrl());
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setServerURL(String url) {
        if (this.verbose) {
            log.info((Object)("replacing JMX service url (" + this.serverURL + ") with " + url));
        }
        this.serverURL = url;
    }

    public void setQuiet(boolean flag) {
        this.quiet = flag;
    }

    public void addCommandPrototype(Command proto) {
        String name = proto.getName();
        log.debug((Object)("Adding command '" + name + "'; proto: " + proto));
        this.commandProtoList.add(proto);
        this.commandProtoMap.put(name, proto);
    }

    private CommandContext createCommandContext() {
        return new CommandContext(){

            public boolean isQuiet() {
                return Twiddle.this.quiet;
            }

            public PrintWriter getWriter() {
                return Twiddle.this.out;
            }

            public PrintWriter getErrorWriter() {
                return Twiddle.this.err;
            }

            public void closeServer() {
                if (Twiddle.this.jmxc != null) {
                    Twiddle.this.server = null;
                    try {
                        Twiddle.this.jmxc.close();
                    }
                    catch (IOException e) {
                        throw new NestedRuntimeException((Throwable)e);
                    }
                }
            }

            public MBeanServerConnection getServer() {
                try {
                    Twiddle.this.connect();
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
                return Twiddle.this.server;
            }
        };
    }

    public Command createCommand(String name) throws NoSuchCommandException, Exception {
        Command proto = (Command)this.commandProtoMap.get(name);
        if (proto == null) {
            throw new NoSuchCommandException(name);
        }
        Command command = (Command)proto.clone();
        command.setCommandContext(this.createCommandContext());
        return command;
    }

    private int getMaxCommandNameLength() {
        int max = 0;
        for (Command command : this.commandProtoList) {
            String name = command.getName();
            if (name.length() <= max) continue;
            max = name.length();
        }
        return max;
    }

    public void displayCommandList() {
        if (this.commandProtoList.size() == 0) {
            try {
                Twiddle.loadCommands();
            }
            catch (Exception e) {
                System.err.println("Failed to load commnads from: " + cmdProps);
                e.printStackTrace();
            }
        }
        Iterator iter = this.commandProtoList.iterator();
        this.out.println(PROGRAM_NAME + " commands: ");
        int maxNameLength = this.getMaxCommandNameLength();
        log.debug((Object)("max command name length: " + maxNameLength));
        while (iter.hasNext()) {
            Command proto = (Command)iter.next();
            String name = proto.getName();
            String desc = proto.getDescription();
            this.out.print("    ");
            this.out.print(name);
            this.out.print(Strings.pad((String)" ", (int)(maxNameLength - name.length())));
            this.out.print("    ");
            this.out.println(desc);
        }
        this.out.flush();
    }

    private JMXConnector createMBeanServerConnection() throws NamingException, IOException {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (this.username != null && this.password != null) {
            if (this.verbose) {
                this.out.println("will connect with username=" + this.username);
            }
            String[] creds = new String[]{this.username, this.password};
            env.put("jmx.remote.credentials", creds);
        }
        JMXServiceURL url = new JMXServiceURL(this.serverURL);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
        return jmxc;
    }

    private void connect() throws NamingException, IOException {
        if (this.server == null) {
            this.jmxc = this.createMBeanServerConnection();
            this.server = this.jmxc.getMBeanServerConnection();
        }
    }

    public static void main(String[] args) {
        Command command = null;
        try {
            Twiddle.initProtocolHandlers();
            Twiddle.processArguments(args);
            Twiddle.loadCommands();
            if (commandName == null) {
                Twiddle.displayHelp();
            } else {
                command = twiddle.createCommand(commandName);
                if (commandHelp) {
                    System.out.println("Help for command: '" + command.getName() + "'");
                    System.out.println();
                    command.displayHelp();
                } else {
                    command.execute(commandArgs);
                }
            }
            System.exit(0);
        }
        catch (CommandException e) {
            log.error((Object)"Command failure", (Throwable)((Object)e));
            System.err.println();
            if (e instanceof NoSuchCommandException) {
                twiddle.displayCommandList();
            } else if (command != null) {
                System.err.println("Help for command: '" + command.getName() + "'");
                System.err.println();
                command.displayHelp();
            }
            System.exit(1);
        }
        catch (Exception e) {
            log.error((Object)"Exec failed", (Throwable)e);
            System.exit(1);
        }
    }

    private static void initProtocolHandlers() {
        String handlerPkgs = System.getProperty("java.protocol.handler.pkgs");
        handlerPkgs = handlerPkgs != null ? handlerPkgs + "|org.jboss.net.protocol" : "org.jboss.net.protocol";
        System.setProperty("java.protocol.handler.pkgs", handlerPkgs);
    }

    private static void loadCommands() throws Exception {
        if (cmdProps == null) {
            cmdProps = Twiddle.class.getResource(CMD_PROPERTIES);
        }
        if (cmdProps == null) {
            throw new IllegalStateException("Failed to find: /org/jboss/console/twiddle/commands.properties");
        }
        InputStream input = cmdProps.openStream();
        log.debug((Object)("command proto type properties: " + cmdProps));
        Properties props = new Properties();
        props.load(input);
        input.close();
        for (String string : props.keySet()) {
            String typeName = props.getProperty(string);
            Class<?> type = Class.forName(typeName);
            twiddle.addCommandPrototype((Command)type.newInstance());
        }
    }

    private static void displayHelp() {
        PrintStream out = System.out;
        out.println("A JMX client to 'twiddle' with a remote JBoss server.");
        out.println();
        out.println("usage: " + PROGRAM_NAME + " [options] <command> [command_arguments]");
        out.println();
        out.println("options:");
        out.println("    -h, --help                Show this help message");
        out.println("        --help-commands       Show a list of commands");
        out.println("    -H<command>               Show command specific help");
        out.println("    -c=command.properties     Specify the command.properties file to use");
        out.println("    -D<name>[=<value>]        Set a system property");
        out.println("    --                        Stop processing options");
        out.println("    -s, --server=<url>        The JMX service URL of the remote server (e.g. service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi) ");
        out.println("    -o, --host=<HOSTNAME>     The name of the remote server (e.g. localhost) ");
        out.println("    -r, --port=<PORTNUMBER>   The rmiRegistryPort of the remote server (e.g. 1090) ");
        out.println("    -u, --user=<name>         Specify the username for authentication");
        out.println("    -p, --password=<name>     Specify the password for authentication");
        out.println("    -q, --quiet               Be somewhat more quiet");
        out.println("    -v, --verbose             Be noisy");
        out.println();
        out.println("for convenience, you can specify --host and --port but not with the --server=<url> which overrides host + port. ");
        out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processArguments(String[] args) throws Exception {
        int code;
        for (int a = 0; a < args.length; ++a) {
            if (Twiddle.logPassword(args, a)) continue;
            log.debug((Object)("args[" + a + "]=" + args[a]));
        }
        String sopts = "-:hH:u:p:c:D:s:a:q::v::o:r:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("help-commands", 0, null, 4096), new LongOpt("server", 1, null, 115), new LongOpt("adapter", 1, null, 97), new LongOpt("quiet", 0, null, 113), new LongOpt("verbose", 0, null, 118), new LongOpt("user", 1, null, 117), new LongOpt("host", 1, null, 111), new LongOpt("port", 1, null, 114), new LongOpt("password", 1, null, 112)};
        Getopt getopt = new Getopt(PROGRAM_NAME, args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    System.exit(1);
                    break;
                }
                case 1: {
                    commandName = getopt.getOptarg();
                    log.debug((Object)("Command name: " + commandName));
                    int i = getopt.getOptind();
                    if (args.length > i) {
                        commandArgs = new String[args.length - i];
                        System.arraycopy(args, i, commandArgs, 0, args.length - i);
                    } else {
                        commandArgs = new String[0];
                    }
                    log.debug((Object)("Command arguments: " + Strings.join((Object[])commandArgs, (String)",")));
                    return;
                }
                case 104: {
                    Twiddle.displayHelp();
                    System.exit(0);
                    break;
                }
                case 72: {
                    commandName = getopt.getOptarg();
                    commandHelp = true;
                    return;
                }
                case 4096: {
                    twiddle.displayCommandList();
                    System.exit(0);
                    break;
                }
                case 99: {
                    String props = getopt.getOptarg();
                    try {
                        cmdProps = new URL(props);
                    }
                    catch (MalformedURLException e) {
                        log.debug((Object)"Failed to use cmd props as url", (Throwable)e);
                        File path = new File(props);
                        if (!path.exists()) {
                            String msg = "Failed to locate command props: " + props + " as URL or file";
                            throw new IllegalArgumentException(msg);
                        }
                        cmdProps = path.toURL();
                    }
                    break;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    break;
                }
                case 111: {
                    twiddle.setHostname(getopt.getOptarg());
                    break;
                }
                case 114: {
                    twiddle.setPort(getopt.getOptarg());
                    break;
                }
                case 115: {
                    twiddle.setServerURL(getopt.getOptarg());
                    break;
                }
                case 97: {
                    String arg = getopt.getOptarg();
                    log.info((Object)("adapter name is ignored " + arg));
                    break;
                }
                case 117: {
                    twiddle.setUsername(getopt.getOptarg());
                    break;
                }
                case 112: {
                    twiddle.setPassword(getopt.getOptarg());
                    break;
                }
                case 118: {
                    twiddle.setVerbose(true);
                    break;
                }
                case 113: {
                    twiddle.setQuiet(true);
                }
            }
        }
    }

    private static boolean logPassword(String[] args, int a) {
        String[] split;
        if (args[a].startsWith("-p") && args[a].length() > 2) {
            log.debug((Object)("args[" + a + "]=-pxxxx"));
            return true;
        }
        if (args[a].indexOf(61) != -1 && "--password".indexOf((split = args[a].split("="))[0]) != -1) {
            log.debug((Object)("args[" + a + "]=" + split[0] + "=xxxx"));
            return true;
        }
        try {
            if (args[a - 1].equals("-p") || args[a - 1].indexOf(61) == -1 && "--password".indexOf(args[a - 1]) != -1) {
                log.debug((Object)("args[" + a + "]=xxxx"));
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }
}

