/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.security.Identity;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.ejb.TransactionManagementType;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.SecurityActions;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.ejb3.tx.UserTransactionImpl;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRoleRef;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.integration.ejb.EJBAuthorizationHelper;
import org.jboss.security.plugins.SecurityContextAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBContextImpl<T extends Container, B extends BeanContext<T>>
implements EJBContext {
    private static final Logger log = Logger.getLogger(EJBContextImpl.class);
    protected transient T container;
    protected transient RealmMapping rm;
    protected B beanContext;
    private Principal beanPrincipal;

    protected EJBContextImpl(B beanContext) {
        assert (beanContext != null) : "beanContext is null";
        this.beanContext = beanContext;
        this.container = beanContext.getContainer();
        this.rm = this.container.getSecurityManager(RealmMapping.class);
    }

    protected T getContainer() {
        return this.container;
    }

    protected RealmMapping getRm() {
        return this.rm;
    }

    public Object lookup(String name) {
        String newName = name.startsWith("/") ? "env" + name : "env/" + name;
        try {
            return this.getContainer().getEnc().lookup(newName);
        }
        catch (NamingException ignored) {
            try {
                return this.getContainer().getInitialContext().lookup(name);
            }
            catch (NamingException ignored2) {
                return null;
            }
        }
    }

    public Identity getCallerIdentity() {
        throw new IllegalStateException("deprecated");
    }

    public Principal getCallerPrincipal() {
        if (this.beanPrincipal == null) {
            String unauth;
            SecurityDomain domain;
            EJBContainer ec = (EJBContainer)this.container;
            Principal callerPrincipal = null;
            RealmMapping rm = this.container.getSecurityManager(RealmMapping.class);
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if (sc == null) {
                domain = (SecurityDomain)ec.resolveAnnotation(SecurityDomain.class);
                unauth = domain.unauthenticatedPrincipal();
                if (unauth != null && unauth.length() > 0 && domain.unauthenticatedPrincipal() != null) {
                    callerPrincipal = new SimplePrincipal(unauth);
                }
            } else {
                EJBAuthorizationHelper helper = new EJBAuthorizationHelper(sc);
                callerPrincipal = helper.getCallerPrincipal(rm);
            }
            if (callerPrincipal == null) {
                callerPrincipal = sc.getUtil().getUserPrincipal();
                if (rm != null) {
                    callerPrincipal = rm.getPrincipal(callerPrincipal);
                }
            }
            if (callerPrincipal == null && (unauth = (domain = (SecurityDomain)ec.resolveAnnotation(SecurityDomain.class)).unauthenticatedPrincipal()) != null && unauth.length() > 0 && domain.unauthenticatedPrincipal() != null) {
                callerPrincipal = new SimplePrincipal(unauth);
            }
            if (callerPrincipal == null) {
                throw new IllegalStateException("No valid security context for the caller identity");
            }
            this.beanPrincipal = callerPrincipal;
        }
        return this.beanPrincipal;
    }

    public boolean isCallerInRole(Identity role) {
        throw new IllegalStateException("deprecated");
    }

    public boolean isCallerInRole(String roleName) {
        SecurityRoleRefsMetaData srf;
        EJBContainer ejbc = (EJBContainer)this.container;
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc == null) {
            SecurityDomain domain = (SecurityDomain)ejbc.resolveAnnotation(SecurityDomain.class);
            try {
                sc = SecurityActions.createSecurityContext(domain.value());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        HashSet roleRefs = new HashSet();
        JBossEnterpriseBeanMetaData eb = ejbc.getXml();
        if (eb != null && (srf = eb.getSecurityRoleRefs()) != null) {
            roleRefs.addAll(srf);
        }
        HashSet<SecurityRoleRef> srset = new HashSet<SecurityRoleRef>();
        for (SecurityRoleRefMetaData srmd : roleRefs) {
            srset.add(new SecurityRoleRef(srmd.getRoleName(), srmd.getRoleLink(), null));
        }
        Principal principal = this.getCallerPrincipal();
        EJBAuthorizationHelper helper = new EJBAuthorizationHelper(sc);
        return helper.isCallerInRole(roleName, ejbc.getEjbName(), principal, srset);
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.getContainer().getTimerService();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)this.getContainer());
        if (type != TransactionManagementType.BEAN) {
            throw new IllegalStateException("Container " + this.getContainer().getEjbName() + ": it is illegal to inject UserTransaction into a CMT bean");
        }
        return new UserTransactionImpl();
    }

    public EJBHome getEJBHome() {
        throw new IllegalStateException("EJB 3.0 does not have a home type.");
    }

    public EJBLocalHome getEJBLocalHome() {
        throw new IllegalStateException("EJB 3.0 does not have a home type.");
    }

    public Properties getEnvironment() {
        throw new EJBException("Deprecated");
    }

    public void setRollbackOnly() throws IllegalStateException {
        TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)this.getContainer());
        if (type != TransactionManagementType.CONTAINER) {
            throw new IllegalStateException("Container " + this.getContainer().getEjbName() + ": it is illegal to call setRollbackOnly from BMT: " + type);
        }
        try {
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
            }
            tm.setRollbackOnly();
        }
        catch (SystemException e) {
            log.warn((Object)"failed to set rollback only; ignoring", (Throwable)e);
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)this.getContainer());
        if (type != TransactionManagementType.CONTAINER) {
            throw new IllegalStateException("Container " + this.getContainer().getEjbName() + ": it is illegal to call getRollbackOnly from BMT: " + type);
        }
        try {
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
            }
            int status = tm.getStatus();
            return status == 1 || status == 9 || status == 4;
        }
        catch (SystemException e) {
            log.warn((Object)"failed to get tx manager status; ignoring", (Throwable)e);
            return true;
        }
    }
}

