/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;

public class InitialContextFactory {
    private static final Logger log = Logger.getLogger(InitialContextFactory.class);
    private static Properties props = null;
    private static Properties securityProperties = null;
    private static InitialContext baseInitialContext = null;
    private static Context haContext = null;
    private static Integer haJndiPort = null;

    public static InitialContext getInitialContext() throws NamingException {
        InitialContext jndiContext;
        if (props == null) {
            if (baseInitialContext == null) {
                baseInitialContext = new InitialContext();
            }
            jndiContext = baseInitialContext;
            try {
                jndiContext.getEnvironment();
            }
            catch (NamingException e) {
                jndiContext = baseInitialContext = new InitialContext();
            }
        } else if (securityProperties != null) {
            Properties combinedProps = new Properties();
            combinedProps.putAll((Map<?, ?>)props);
            combinedProps.putAll((Map<?, ?>)securityProperties);
            jndiContext = new InitialContext(combinedProps);
        } else {
            jndiContext = new InitialContext(props);
        }
        return jndiContext;
    }

    public static InitialContext getInitialContext(Hashtable props) throws NamingException {
        InitialContext ctx = null;
        ctx = props != null ? new InitialContext(props) : InitialContextFactory.getInitialContext();
        return ctx;
    }

    public static Context getHAContext(Context ctx) throws NamingException {
        Hashtable<?, ?> env;
        Object providerUrl;
        if (haContext == null && (providerUrl = (env = ctx.getEnvironment()).get("java.naming.provider.url")) == null) {
            try {
                String bindAddress = System.getProperty("jboss.bind.address");
                env.put("java.naming.provider.url", bindAddress + ":" + InitialContextFactory.getHaJndiPort());
                InitialContext haCtx = new InitialContext(env);
                haCtx.bind("HA_TEST", null);
                haCtx.unbind("HA_TEST");
                haContext = haCtx;
            }
            catch (Exception e) {
                log.debug((Object)("Unable to access HA JNDI: " + e));
            }
        }
        return haContext;
    }

    private static Integer getHaJndiPort() throws Exception {
        if (haJndiPort == null) {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            ObjectName objectName = new ObjectName("jboss:service=HAJNDI");
            haJndiPort = (Integer)server.getAttribute(objectName, "Port");
        }
        return haJndiPort;
    }

    public static void setProperties(Properties properties) {
        props = properties;
    }

    public static void setSecurity(String user, String password) {
        if (props != null) {
            securityProperties = new Properties();
            securityProperties.put("java.naming.security.principal", user);
            securityProperties.put("java.naming.security.credentials", password);
            securityProperties.put("java.naming.factory.initial", "org.jboss.security.jndi.JndiLoginInitialContextFactory");
        }
    }
}

