/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.simple;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import javax.ejb.EJBException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.cache.simple.StatefulSessionPersistenceManager;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.serial.io.JBossObjectInputStream;
import org.jboss.serial.io.JBossObjectOutputStream;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.id.UID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionFilePersistenceManager
implements StatefulSessionPersistenceManager {
    private String storeDirName = "sessions";
    private File storeDir;
    private Container con;
    private boolean purgeEnabled = true;

    public void setStoreDirectoryName(String dirName) {
        this.storeDirName = dirName;
    }

    public String getStoreDirectoryName() {
        return this.storeDirName;
    }

    public void setPurgeEnabled(boolean flag) {
        this.purgeEnabled = flag;
    }

    public boolean getPurgeEnabled() {
        return this.purgeEnabled;
    }

    public File getStoreDirectory() {
        return this.storeDir;
    }

    public void setContainer(Container con) {
        this.con = con;
    }

    @Override
    public void initialize(Container con) throws Exception {
        this.con = con;
        boolean debug = log.isDebugEnabled();
        String ejbName = con.getEjbName();
        File dir = ServerConfigLocator.locate().getServerTempDir();
        dir = new File(dir, this.storeDirName);
        this.storeDir = dir = new File(dir, ejbName + "-" + new UID().toString());
        if (debug) {
            log.debug((Object)("Storing sessions for '" + ejbName + "' in: " + this.storeDir));
        }
        if (!this.storeDir.exists() && !MkdirsFileAction.mkdirs(this.storeDir)) {
            throw new IOException("Failed to create directory: " + this.storeDir);
        }
        if (!this.storeDir.isDirectory()) {
            throw new IOException("File exists where directory expected: " + this.storeDir);
        }
        if (!this.storeDir.canWrite() || !this.storeDir.canRead()) {
            throw new IOException("Directory must be readable and writable: " + this.storeDir);
        }
        this.purgeAllSessionData();
    }

    public void purgeAllSessionData() {
        if (!this.purgeEnabled) {
            return;
        }
        log.debug((Object)("Purging all session data in: " + this.storeDir));
        File[] sessions = this.storeDir.listFiles();
        for (int i = 0; i < sessions.length; ++i) {
            if (!sessions[i].delete()) {
                log.warn((Object)("Failed to delete session state file: " + sessions[i]));
                continue;
            }
            log.debug((Object)("Removed stale session state: " + sessions[i]));
        }
    }

    @Override
    public void destroy() throws Exception {
        this.purgeAllSessionData();
        if (this.purgeEnabled && !this.storeDir.delete()) {
            log.warn((Object)("Failed to delete session state storage directory: " + this.storeDir));
        }
    }

    private File getFile(Object id) {
        return new File(this.storeDir, String.valueOf(id) + ".ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulBeanContext activateSession(Object id) {
        File file;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Attempting to activate; id=" + id));
        }
        if (!(file = this.getFile(id)).exists()) {
            return null;
        }
        if (debug) {
            log.debug((Object)("Reading session state from: " + file));
        }
        StatefulBeanContext bean = null;
        try {
            FileInputStream fis = FISAction.open(file);
            JBossObjectInputStream in = new JBossObjectInputStream((InputStream)new BufferedInputStream(fis));
            try {
                bean = (StatefulBeanContext)in.readObject();
            }
            finally {
                fis.close();
                in.close();
            }
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Could not activate; failed to restore state", e);
        }
        this.removePassivated(id);
        bean.postActivate();
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StatefulBeanContext> getPassivatedBeans() {
        File[] files;
        LinkedList<StatefulBeanContext> beans = new LinkedList<StatefulBeanContext>();
        for (File file : files = this.storeDir.listFiles()) {
            try {
                FileInputStream fis = FISAction.open(file);
                JBossObjectInputStream in = new JBossObjectInputStream((InputStream)new BufferedInputStream(fis));
                try {
                    StatefulBeanContext bean = (StatefulBeanContext)in.readObject();
                    beans.add(bean);
                }
                finally {
                    fis.close();
                    in.close();
                }
            }
            catch (Exception e) {
                log.warn((Object)("Could not read for timeout removal for file " + file.getName()), (Throwable)e);
            }
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passivateSession(StatefulBeanContext ctx) {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Attempting to passivate; id=" + ctx.getId()));
        }
        ctx.prePassivate();
        File file = this.getFile(ctx.getId());
        if (debug) {
            log.debug((Object)("Saving session state to: " + file));
        }
        try {
            FileOutputStream fos = FOSAction.open(file);
            JBossObjectOutputStream out = new JBossObjectOutputStream((OutputStream)fos, false);
            try {
                out.writeObject(ctx);
                out.flush();
                fos.flush();
                fos.close();
            }
            finally {
                out.close();
            }
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Could not passivate; failed to save state", e);
        }
        if (debug) {
            log.debug((Object)("Passivation complete; id=" + ctx.getId()));
        }
    }

    @Override
    public void removePassivated(Object id) {
        boolean debug = log.isDebugEnabled();
        File file = this.getFile(id);
        if (file.exists()) {
            if (debug) {
                log.debug((Object)("Removing passivated state file: " + file));
            }
            if (!DeleteFileAction.delete(file)) {
                log.warn((Object)("Failed to delete passivated state file: " + file));
            }
        }
    }

    static class FOSAction
    implements PrivilegedExceptionAction {
        File file;

        FOSAction(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            FileOutputStream fis = new FileOutputStream(this.file);
            return fis;
        }

        static FileOutputStream open(File file) throws FileNotFoundException {
            FOSAction action = new FOSAction(file);
            FileOutputStream fos = null;
            try {
                fos = (FileOutputStream)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fos;
        }
    }

    static class FISAction
    implements PrivilegedExceptionAction {
        File file;

        FISAction(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            FileInputStream fis = new FileInputStream(this.file);
            return fis;
        }

        static FileInputStream open(File file) throws FileNotFoundException {
            FISAction action = new FISAction(file);
            FileInputStream fis = null;
            try {
                fis = (FileInputStream)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fis;
        }
    }

    static class MkdirsFileAction
    implements PrivilegedAction {
        File file;

        MkdirsFileAction(File file) {
            this.file = file;
        }

        public Object run() {
            boolean ok = this.file.mkdirs();
            return new Boolean(ok);
        }

        static boolean mkdirs(File file) {
            MkdirsFileAction action = new MkdirsFileAction(file);
            Boolean ok = (Boolean)AccessController.doPrivileged(action);
            return ok;
        }
    }

    static class DeleteFileAction
    implements PrivilegedAction {
        File file;

        DeleteFileAction(File file) {
            this.file = file;
        }

        public Object run() {
            boolean deleted = this.file.delete();
            return new Boolean(deleted);
        }

        static boolean delete(File file) {
            DeleteFileAction action = new DeleteFileAction(file);
            Boolean deleted = (Boolean)AccessController.doPrivileged(action);
            return deleted;
        }
    }
}

