/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.Option;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.NodeActivatedEvent;
import org.jboss.cache.notifications.event.NodePassivatedEvent;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.CacheConfig;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.cache.tree.AbortableLRUPolicy;
import org.jboss.ejb3.cache.tree.ContextInUseException;
import org.jboss.ejb3.pool.Pool;
import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
import org.jboss.ejb3.stateful.ProxiedStatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.id.GUID;

public class StatefulTreeCache
implements ClusteredStatefulCache {
    private static final int FQN_SIZE = 3;
    private static final int DEFAULT_BUCKET_COUNT = 100;
    private static final String[] DEFAULT_HASH_BUCKETS = new String[100];
    private static Option LOCAL_ONLY_OPTION = new Option();
    private static Option GRAVITATE_OPTION = new Option();
    private ThreadLocal<Boolean> localActivity = new ThreadLocal();
    private Logger log = Logger.getLogger(StatefulTreeCache.class);
    private Pool pool;
    private WeakReference<ClassLoader> classloader;
    private Cache cache;
    private Fqn cacheNode;
    private Region region;
    private ClusteredStatefulCacheListener listener;
    public static long MarkInUseWaitTime;
    protected String[] hashBuckets = DEFAULT_HASH_BUCKETS;
    protected int createCount = 0;
    protected int passivatedCount = 0;
    protected int removeCount = 0;
    protected long removalTimeout = 0L;
    protected RemovalTimeoutTask removalTask = null;
    protected boolean running = true;
    protected Map<Object, Long> beans = new ConcurrentHashMap<Object, Long>();
    protected EJBContainer ejbContainer;

    public StatefulBeanContext create() {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching context " + ctx.getId() + " of type " + ctx.getClass()));
            }
            this.putInCache(ctx);
            ctx.setInUse(true);
            ctx.lastUsed = System.currentTimeMillis();
            ++this.createCount;
            this.beans.put(ctx.getId(), new Long(ctx.lastUsed));
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching context " + ctx.getId() + " of type " + ctx.getClass()));
            }
            this.putInCache(ctx);
            ctx.setInUse(true);
            ctx.lastUsed = System.currentTimeMillis();
            ++this.createCount;
            this.beans.put(ctx.getId(), new Long(ctx.lastUsed));
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        Fqn id = this.getFqn(key, false);
        Boolean active = this.localActivity.get();
        try {
            this.localActivity.set(Boolean.TRUE);
            InvocationContext ictx = this.cache.getInvocationContext();
            ictx.setOptionOverrides(StatefulTreeCache.getGravitateOption());
            entry = (StatefulBeanContext)this.cache.get(id, (Object)"bean");
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
        finally {
            this.localActivity.set(active);
        }
        if (entry == null) {
            throw new NoSuchEJBException("Could not find stateful bean: " + key);
        }
        if (markInUse && entry.isRemoved()) {
            throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed)");
        }
        entry.postReplicate();
        if (markInUse) {
            entry.setInUse(true);
            this.region.markNodeCurrentlyInUse(new Fqn(new Object[]{key.toString()}), MarkInUseWaitTime);
            entry.lastUsed = System.currentTimeMillis();
            this.beans.put(key, new Long(entry.lastUsed));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("get: retrieved bean with cache id " + id.toString()));
        }
        return entry;
    }

    public StatefulBeanContext peek(Object key) throws NoSuchEJBException {
        return this.get(key, false);
    }

    public void remove(Object key) {
        Fqn id = this.getFqn(key, false);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("remove: cache id " + id.toString()));
            }
            InvocationContext ictx = this.cache.getInvocationContext();
            ictx.setOptionOverrides(StatefulTreeCache.getGravitateOption());
            StatefulBeanContext ctx = (StatefulBeanContext)this.cache.get(id, (Object)"bean");
            if (ctx != null) {
                if (!ctx.isRemoved()) {
                    this.pool.remove(ctx);
                }
                if (ctx.getCanRemoveFromCache()) {
                    this.cache.removeNode(id);
                } else {
                    this.putInCache(ctx);
                }
                ++this.removeCount;
                this.beans.remove(key);
            }
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
            this.beans.put(ctx.getId(), new Long(ctx.lastUsed));
            this.region.unmarkNodeCurrentlyInUse(this.getFqn(ctx.getId(), true));
        }
    }

    public void replicate(StatefulBeanContext ctx) {
        if (ctx instanceof NestedStatefulBeanContext) {
            throw new IllegalArgumentException("Received unexpected replicate call for nested context " + ctx.getId());
        }
        try {
            this.putInCache(ctx);
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
    }

    public void initialize(Container container) throws Exception {
        this.ejbContainer = (EJBContainer)container;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.ejbContainer.getEjbName()));
        this.pool = this.ejbContainer.getPool();
        ClassLoader cl = this.ejbContainer.getClassloader();
        this.classloader = new WeakReference<ClassLoader>(cl);
        EJBContainer advisor = this.ejbContainer;
        CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
        MBeanServer server = MBeanServerLocator.locateJBoss();
        String name = config.name();
        if (name == null || name.trim().length() == 0) {
            name = "jboss.cache:service=EJB3SFSBClusteredCache";
        }
        ObjectName cacheON = new ObjectName(name);
        CacheJmxWrapperMBean mbean = (CacheJmxWrapperMBean)MBeanProxyExt.create(CacheJmxWrapperMBean.class, (ObjectName)cacheON, (MBeanServer)server);
        this.cache = mbean.getCache();
        this.cacheNode = new Fqn(new Object[]{this.ejbContainer.getDeploymentQualifiedName()});
        this.region = this.cache.getRegion(this.cacheNode, true);
        EvictionPolicyConfig epc = this.getEvictionPolicyConfig((int)config.idleTimeoutSeconds(), config.maxSize());
        this.region.setEvictionPolicy(epc);
        this.cleanBeanRegion();
        this.region.registerContextClassLoader(cl);
        this.region.activate();
        this.log.debug((Object)("initialize(): created region: " + this.region + " for ejb: " + this.ejbContainer.getEjbName()));
        this.removalTimeout = config.removalTimeoutSeconds();
        if (this.removalTimeout > 0L) {
            this.removalTask = new RemovalTimeoutTask("SFSB Removal Thread - " + this.ejbContainer.getObjectName().getCanonicalName());
        }
    }

    protected EvictionPolicyConfig getEvictionPolicyConfig(int timeToLiveSeconds, int maxNodes) {
        LRUConfiguration epc = new LRUConfiguration();
        epc.setEvictionPolicyClass(AbortableLRUPolicy.class.getName());
        epc.setTimeToLiveSeconds(timeToLiveSeconds);
        epc.setMaxNodes(maxNodes);
        return epc;
    }

    public void start() {
        this.listener = new ClusteredStatefulCacheListener();
        this.cache.addCacheListener((Object)this.listener);
        if (this.removalTask != null) {
            this.removalTask.start();
        }
        this.running = true;
    }

    public void stop() {
        this.running = false;
        if (this.cache != null) {
            if (this.listener != null) {
                this.cache.removeCacheListener((Object)this.listener);
            }
            this.cleanBeanRegion();
            try {
                InvocationContext ctx = this.cache.getInvocationContext();
                ctx.setOptionOverrides(StatefulTreeCache.getLocalOnlyOption());
                this.cache.removeNode(this.cacheNode);
            }
            catch (CacheException e) {
                this.log.error((Object)"stop(): can't remove bean from the underlying distributed cache");
            }
            if (this.region != null) {
                this.region.deactivate();
                this.region.unregisterContextClassLoader();
                ((CacheSPI)this.cache).getRegionManager().removeRegion(this.region.getFqn());
                this.region.resetEvictionQueues();
                this.region = null;
            }
        }
        this.classloader = null;
        if (this.removalTask != null) {
            this.removalTask.interrupt();
        }
        this.log.debug((Object)("stop(): StatefulTreeCache stopped successfully for " + this.cacheNode));
    }

    public int getCacheSize() {
        int count = 0;
        try {
            Set children = null;
            for (int i = 0; i < this.hashBuckets.length; ++i) {
                Node node = this.cache.getRoot().getChild(new Fqn(this.cacheNode, new Object[]{this.hashBuckets[i]}));
                if (node == null) continue;
                children = node.getChildrenNames();
                count += children == null ? 0 : children.size();
            }
            count -= this.passivatedCount;
        }
        catch (CacheException e) {
            this.log.error((Object)"Caught exception calculating cache size", (Throwable)e);
            count = -1;
        }
        return count;
    }

    public int getTotalSize() {
        return this.beans.size();
    }

    public int getCreateCount() {
        return this.createCount;
    }

    public int getPassivatedCount() {
        return this.passivatedCount;
    }

    public int getRemoveCount() {
        return this.removeCount;
    }

    public int getAvailableCount() {
        return -1;
    }

    public int getMaxSize() {
        return -1;
    }

    public int getCurrentSize() {
        return this.getCacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(StatefulBeanContext ctx) {
        Boolean active = this.localActivity.get();
        try {
            this.localActivity.set(Boolean.TRUE);
            ctx.preReplicate();
            this.cache.put(this.getFqn(ctx.getId(), false), (Object)"bean", (Object)ctx);
            ctx.markedForReplication = false;
        }
        finally {
            this.localActivity.set(active);
        }
    }

    private Fqn getFqn(Object id, boolean regionRelative) {
        String beanId = id.toString();
        int index = id instanceof GUID ? (id.hashCode() & Integer.MAX_VALUE) % this.hashBuckets.length : (beanId.hashCode() & Integer.MAX_VALUE) % this.hashBuckets.length;
        if (regionRelative) {
            return new Fqn(new Object[]{this.hashBuckets[index], beanId});
        }
        return new Fqn(this.cacheNode, new Object[]{this.hashBuckets[index], beanId});
    }

    private void cleanBeanRegion() {
        try {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.cache.removeNode(this.cacheNode);
        }
        catch (CacheException e) {
            this.log.error((Object)"Stop(): can't remove bean from the underlying distributed cache");
        }
    }

    private RuntimeException convertToRuntimeException(CacheException e) {
        RuntimeException re = new RuntimeException(((Object)((Object)e)).getClass().getName() + " " + e.getMessage());
        re.setStackTrace(e.getStackTrace());
        return re;
    }

    private static Option getLocalOnlyOption() {
        return LOCAL_ONLY_OPTION.clone();
    }

    private static Option getGravitateOption() {
        return GRAVITATE_OPTION.clone();
    }

    static {
        LOCAL_ONLY_OPTION.setCacheModeLocal(true);
        GRAVITATE_OPTION.setForceDataGravitation(true);
        for (int i = 0; i < DEFAULT_HASH_BUCKETS.length; ++i) {
            StatefulTreeCache.DEFAULT_HASH_BUCKETS[i] = String.valueOf(i);
        }
        MarkInUseWaitTime = 15000L;
    }

    private class RemovalTimeoutTask
    extends Thread {
        public RemovalTimeoutTask(String name) {
            super(name);
        }

        public void run() {
            while (StatefulTreeCache.this.running) {
                try {
                    Thread.sleep(StatefulTreeCache.this.removalTimeout * 1000L);
                }
                catch (InterruptedException e) {
                    StatefulTreeCache.this.running = false;
                    return;
                }
                try {
                    long now = System.currentTimeMillis();
                    for (Map.Entry<Object, Long> entry : StatefulTreeCache.this.beans.entrySet()) {
                        long lastUsed = entry.getValue();
                        if (now - lastUsed < StatefulTreeCache.this.removalTimeout * 1000L) continue;
                        StatefulTreeCache.this.remove(entry.getKey());
                    }
                }
                catch (Exception ex) {
                    StatefulTreeCache.this.log.error((Object)"problem removing SFSB thread", (Throwable)ex);
                }
            }
        }
    }

    @CacheListener
    public class ClusteredStatefulCacheListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NodeActivated
        public void nodeActivated(NodeActivatedEvent event) {
            if (event.isPre()) {
                return;
            }
            Map nodeData = event.getData();
            if (nodeData == null) {
                return;
            }
            Fqn fqn = event.getFqn();
            if (fqn.size() != 3) {
                return;
            }
            if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                return;
            }
            if (Boolean.TRUE != StatefulTreeCache.this.localActivity.get()) {
                --StatefulTreeCache.this.passivatedCount;
                return;
            }
            StatefulBeanContext bean = (StatefulBeanContext)nodeData.get("bean");
            if (bean == null) {
                throw new IllegalStateException("nodeLoaded(): null bean instance.");
            }
            --StatefulTreeCache.this.passivatedCount;
            if (StatefulTreeCache.this.log.isTraceEnabled()) {
                StatefulTreeCache.this.log.trace((Object)("nodeLoaded(): send postActivate event to bean at fqn: " + fqn));
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                bean.activateAfterReplication();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NodePassivated
        public void nodePassivated(NodePassivatedEvent event) {
            block17: {
                if (!event.isPre()) {
                    return;
                }
                Fqn fqn = event.getFqn();
                if (fqn.size() != 3) {
                    return;
                }
                if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                    return;
                }
                StatefulBeanContext bean = null;
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                Boolean active = (Boolean)StatefulTreeCache.this.localActivity.get();
                try {
                    StatefulTreeCache.this.localActivity.set(Boolean.TRUE);
                    bean = (StatefulBeanContext)event.getData().get("bean");
                    if (bean != null) {
                        ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
                        if (cl != null) {
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        if (!bean.getCanPassivate()) {
                            throw new ContextInUseException("Cannot passivate bean " + fqn + " -- it or one if its children is currently in use");
                        }
                        if (StatefulTreeCache.this.log.isTraceEnabled()) {
                            StatefulTreeCache.this.log.trace((Object)("nodePassivated(): send prePassivate event to bean at fqn: " + fqn));
                        }
                        bean.passivateAfterReplication();
                        ++StatefulTreeCache.this.passivatedCount;
                    }
                }
                catch (NoSuchEJBException e) {
                    if (bean instanceof ProxiedStatefulBeanContext) {
                        try {
                            bean.getContainedIn();
                            throw e;
                        }
                        catch (NoSuchEJBException n) {
                            StatefulTreeCache.this.log.debug((Object)("nodePassivated(): removing orphaned proxy at " + fqn));
                            try {
                                StatefulTreeCache.this.cache.removeNode(fqn);
                            }
                            catch (CacheException c) {
                                StatefulTreeCache.this.log.error((Object)("nodePassivated(): could not remove orphaned proxy at " + fqn), (Throwable)c);
                            }
                            break block17;
                        }
                    }
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                    StatefulTreeCache.this.localActivity.set(active);
                }
            }
        }
    }
}

