/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.embedded.EJB3StandaloneDeployment;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3StandaloneDeployer {
    protected static final Logger log = Logger.getLogger(EJB3StandaloneDeployer.class);
    protected Set<URL> archives = new HashSet<URL>();
    protected Set<URL> deployDirs = new HashSet<URL>();
    protected Set<String> archivesByResource = new HashSet<String>();
    protected Set<String> deployDirsByResource = new HashSet<String>();
    protected ClassLoader classLoader;
    private Map defaultPersistenceProperties;
    private Hashtable jndiProperties;
    private List<EJB3StandaloneDeployment> deployments = new ArrayList<EJB3StandaloneDeployment>();
    private Kernel kernel;
    private MBeanServer mbeanServer;

    public EJB3StandaloneDeployer() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public Set<URL> getArchives() {
        return this.archives;
    }

    public void setArchives(Set archives) {
        new Exception().printStackTrace();
        this.archives = archives;
    }

    public Set<URL> getDeployDirs() {
        return this.deployDirs;
    }

    public void setDeployDirs(Set deployDirs) {
        this.deployDirs = deployDirs;
    }

    public Set<String> getArchivesByResource() {
        return this.archivesByResource;
    }

    public void setArchivesByResource(Set archivesByResource) {
        this.archivesByResource = archivesByResource;
    }

    public Set<String> getDeployDirsByResource() {
        return this.deployDirsByResource;
    }

    public void setDeployDirsByResource(Set deployDirsByResource) {
        this.deployDirsByResource = deployDirsByResource;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Map getDefaultPersistenceProperties() {
        return this.defaultPersistenceProperties;
    }

    public void setDefaultPersistenceProperties(Map defaultPersistenceProperties) {
        this.defaultPersistenceProperties = defaultPersistenceProperties;
    }

    public Hashtable getJndiProperties() {
        return this.jndiProperties;
    }

    public void setJndiProperties(Hashtable jndiProperties) {
        this.jndiProperties = jndiProperties;
    }

    public List<EJB3StandaloneDeployment> getDeployments() {
        return this.deployments;
    }

    public void setDeployments(List<EJB3StandaloneDeployment> deployments) {
        this.deployments = deployments;
    }

    public static URL getContainingUrlFromResource(URL url, String resource) throws Exception {
        if (url.getProtocol().equals("jar")) {
            URL jarURL = url;
            URLConnection urlConn = jarURL.openConnection();
            JarURLConnection jarConn = (JarURLConnection)urlConn;
            String parentArchiveName = jarConn.getJarFile().getName();
            File fp = new File(parentArchiveName);
            return fp.toURL();
        }
        String base = url.toString();
        int idx = base.lastIndexOf(resource);
        base = base.substring(0, idx);
        return new URL(base);
    }

    public static URL getDeployDirFromResource(URL url, String resource) throws Exception {
        if (url.getProtocol().equals("jar")) {
            URL jarURL = url;
            URLConnection urlConn = jarURL.openConnection();
            JarURLConnection jarConn = (JarURLConnection)urlConn;
            String parentArchiveName = jarConn.getJarFile().getName();
            File fp = new File(parentArchiveName);
            return fp.getParentFile().toURL();
        }
        String base = url.toString();
        int idx = base.lastIndexOf(resource);
        base = base.substring(0, idx);
        File fp = new File(base);
        return fp.getParentFile().toURL();
    }

    public void create() throws Exception {
        try {
            URL url;
            Enumeration<URL> urls;
            for (String resource : this.deployDirsByResource) {
                urls = this.classLoader.getResources(resource);
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    URL deployUrl = EJB3StandaloneDeployer.getDeployDirFromResource(url, resource);
                    this.deployDirs.add(deployUrl);
                }
            }
            for (URL url2 : this.deployDirs) {
                File dir = new File(url2.toURI());
                for (File fp : dir.listFiles()) {
                    if (fp.isDirectory()) {
                        this.archives.add(fp.toURL());
                        continue;
                    }
                    try {
                        ZipFile zip = new ZipFile(fp);
                        zip.entries();
                        zip.close();
                        this.archives.add(fp.toURL());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            for (String resource : this.archivesByResource) {
                urls = this.classLoader.getResources(resource);
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    URL archiveUrl = EJB3StandaloneDeployer.getContainingUrlFromResource(url, resource);
                    this.archives.add(archiveUrl);
                }
            }
            if (this.defaultPersistenceProperties == null) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("default.persistence.properties");
                if (is == null) {
                    throw new RuntimeException("cannot find default.persistence.properties");
                }
                Properties defaults = new Properties();
                defaults.load(is);
                this.defaultPersistenceProperties = defaults;
            }
            for (URL archive : this.archives) {
                DeployerUnit du = new DeployerUnit(this.classLoader, archive, this.defaultPersistenceProperties, this.jndiProperties);
                EJB3StandaloneDeployment deployment = new EJB3StandaloneDeployment(du, this.kernel, this.mbeanServer);
                this.deployments.add(deployment);
                deployment.create();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void lookup(String name) {
        System.out.println("lookup " + name);
        try {
            InitialContext jndiContext = InitialContextFactory.getInitialContext();
            NamingEnumeration<NameClassPair> names = jndiContext.list(name);
            if (names != null) {
                while (names.hasMore()) {
                    System.out.println("  " + names.next());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() throws Exception {
        try {
            this.loadMbeanServer();
            for (EJB3StandaloneDeployment deployment : this.deployments) {
                if (deployment.getMbeanServer() == null) {
                    deployment.setMbeanServer(this.mbeanServer);
                }
                deployment.start();
                this.lookup("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void loadMbeanServer() {
        if (this.mbeanServer == null) {
            ArrayList<MBeanServer> servers;
            ControllerContext context = this.kernel.getController().getInstalledContext((Object)"MBeanServer");
            this.mbeanServer = context != null ? (MBeanServer)context.getTarget() : ((servers = MBeanServerFactory.findMBeanServer(null)).size() == 0 ? MBeanServerFactory.createMBeanServer() : MBeanServerFactory.findMBeanServer(null).get(0));
        }
    }

    public void stop() throws Exception {
        for (EJB3StandaloneDeployment deployment : this.deployments) {
            deployment.stop();
        }
    }

    public void destroy() throws Exception {
        for (EJB3StandaloneDeployment deployment : this.deployments) {
            deployment.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeployerUnit
    implements DeploymentUnit {
        private URL url;
        private ClassLoader resourceLoader;
        private ClassLoader loader;
        private Map defaultProps;
        private Hashtable jndiProperties;
        private InterceptorInfoRepository interceptorInfoRepository;
        private VirtualFile vfsRoot;

        public DeployerUnit(ClassLoader loader, URL url, Map defaultProps, Hashtable jndiProperties) {
            this.loader = loader;
            this.url = url;
            URL[] urls = new URL[]{url};
            URL[] empty = new URL[]{};
            URLClassLoader parent = new URLClassLoader(empty){

                public URL getResource(String name) {
                    return null;
                }
            };
            this.resourceLoader = new URLClassLoader(urls, (ClassLoader)parent);
            this.defaultProps = defaultProps;
            this.jndiProperties = jndiProperties;
            try {
                VFS vfs = VFS.getVFS((URL)url);
                this.vfsRoot = vfs.getRoot();
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
            this.interceptorInfoRepository = new InterceptorInfoRepository(loader);
        }

        @Override
        public VirtualFile getRootFile() {
            return this.vfsRoot;
        }

        @Override
        public URL getRelativeURL(String jar) {
            URL url = null;
            try {
                url = new URL(jar);
            }
            catch (MalformedURLException e) {
                try {
                    if (jar.startsWith("..")) {
                        if (this.getUrl() == null) {
                            throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
                        }
                        String base = this.getUrl().toString();
                        jar = jar.replaceAll("\\.\\./", "+");
                        int idx = jar.lastIndexOf(43);
                        jar = jar.substring(idx + 1);
                        for (int i = 0; i < idx + 1; ++i) {
                            int slash = base.lastIndexOf(47);
                            base = base.substring(0, slash + 1);
                        }
                        url = new URL(base + jar.substring(idx));
                    } else {
                        File fp = new File(jar);
                        url = fp.toURL();
                    }
                }
                catch (MalformedURLException e1) {
                    throw new RuntimeException("Unable to find relative url: " + jar, e1);
                }
            }
            return url;
        }

        @Override
        public List<VirtualFile> getResources(VirtualFileFilter filter) {
            VisitorAttributes va = new VisitorAttributes();
            va.setLeavesOnly(true);
            SuffixesExcludeFilter noJars = new SuffixesExcludeFilter((Collection)JarUtils.getSuffixes());
            va.setRecurseFilter((VirtualFileFilter)noJars);
            FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
            try {
                this.vfsRoot.visit((VirtualFileVisitor)visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return visitor.getMatched();
        }

        @Override
        public Hashtable getJndiProperties() {
            return this.jndiProperties;
        }

        @Override
        public URL getPersistenceXml() {
            return this.getResourceLoader().getResource("META-INF/persistence.xml");
        }

        @Override
        public URL getEjbJarXml() {
            return this.getResourceLoader().getResource("META-INF/ejb-jar.xml");
        }

        @Override
        public URL getJbossXml() {
            return this.getResourceLoader().getResource("META-INF/jboss.xml");
        }

        @Override
        public List<Class> getClasses() {
            return null;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.loader;
        }

        @Override
        public ClassLoader getResourceLoader() {
            return this.resourceLoader;
        }

        @Override
        public String getShortName() {
            String url = this.getUrl().toString();
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            int dotIdx = url.lastIndexOf(46);
            int slashIdx = url.lastIndexOf(47);
            String name = null;
            name = slashIdx > dotIdx ? url.substring(url.lastIndexOf(47) + 1) : url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf(46));
            return name;
        }

        @Override
        public URL getUrl() {
            return this.url;
        }

        @Override
        public String getDefaultEntityManagerName() {
            return this.getShortName();
        }

        @Override
        public Map getDefaultPersistenceProperties() {
            return this.defaultProps;
        }

        @Override
        public InterceptorInfoRepository getInterceptorInfoRepository() {
            return this.interceptorInfoRepository;
        }

        @Override
        public VirtualFile getMetaDataFile(String path) {
            try {
                return this.vfsRoot.getChild(path);
            }
            catch (IOException e) {
                log.debug((Object)("Cannot get meta data file: " + path));
                return null;
            }
        }
    }
}

