/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.annotation.MessageProperties;
import org.jboss.ejb3.annotation.Producer;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.ProducerFactory;
import org.jboss.ejb3.mdb.ProducerManagerImpl;
import org.jboss.ejb3.mdb.ProducerObject;
import org.jboss.ejb3.mdb.ProducerProxy;
import org.jboss.naming.Util;

public class RemoteProducerFactory
extends ProducerFactory {
    protected ConnectionFactory factory;

    public RemoteProducerFactory(ConsumerContainer container, Class producer, MessageProperties props, Destination dest, InitialContext ctx, Hashtable initialContextProperties) {
        super(container, producer, props, dest, ctx, initialContextProperties);
        try {
            String factoryName = this.pImpl.connectionFactory();
            if (factoryName.equals("")) {
                factoryName = "ConnectionFactory";
            }
            this.factory = (ConnectionFactory)ctx.lookup(factoryName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setContainer(Container container) {
    }

    public Object createProxy() {
        Class[] interfaces = new Class[]{this.producer, ProducerObject.class};
        ProducerManagerImpl mImpl = null;
        mImpl = new ProducerManagerImpl((Producer)this.pImpl, this.dest, this.factory, this.props.delivery(), this.props.timeToLive(), this.props.priority(), this.methodMap, this.initialContextProperties);
        Interceptor[] interceptors = new Interceptor[]{mImpl};
        ProducerProxy ih = new ProducerProxy(mImpl, interceptors);
        return Proxy.newProxyInstance(this.producer.getClassLoader(), interfaces, (InvocationHandler)ih);
    }

    public void start() throws Exception {
        super.start();
        Class[] interfaces = new Class[]{ProxyFactory.class};
        Object factoryProxy = Remoting.createPojiProxy((Object)(this.jndiName + "PRODUCER_FACTORY"), (Class[])interfaces, (String)"socket://0.0.0.0:3873");
        try {
            Util.rebind((Context)this.ctx, (String)(this.jndiName + "PRODUCER_FACTORY"), (Object)factoryProxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind remote producer factory into JNDI under jndiName: " + this.ctx.getNameInNamespace() + "/" + this.jndiName + "PRODUCER_FACTORY");
            namingException.setRootCause(e);
            throw namingException;
        }
        Dispatcher.singleton.registerTarget((Object)(this.jndiName + "PRODUCER_FACTORY"), (Object)this);
    }

    public void stop() throws Exception {
        super.stop();
        Util.unbind((Context)this.ctx, (String)(this.jndiName + "PRODUCER_FACTORY"));
        Dispatcher.singleton.unregisterTarget((Object)(this.jndiName + "PRODUCER_FACTORY"));
    }
}

