/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.pool.Pool;
import org.jboss.ejb3.stateful.StatefulInstanceInterceptor;
import org.jboss.logging.Logger;

public class StatelessInstanceInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(StatelessInstanceInterceptor.class);

    public String getName() {
        return "StatelessInstanceInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        EJBContainerInvocation ejb = (EJBContainerInvocation)invocation;
        Object container = ejb.getAdvisor();
        Pool pool = ((EJBContainer)container).getPool();
        BeanContext<?> ctx = pool.get();
        ejb.setTargetObject(ctx.getInstance());
        ejb.setBeanContext(ctx);
        ((EJBContainer)container).pushContext(ctx);
        boolean discard = false;
        try {
            Object object = ejb.invokeNext();
            return object;
        }
        catch (Exception ex) {
            discard = ex instanceof EJBException || (ex instanceof RuntimeException || ex instanceof RemoteException) && !StatefulInstanceInterceptor.isApplicationException(ex.getClass(), container);
            throw ex;
        }
        finally {
            ((EJBContainer)container).popContext();
            ejb.setTargetObject(null);
            ejb.setBeanContext(null);
            if (discard) {
                pool.discard(ctx);
            } else {
                pool.release(ctx);
            }
        }
    }
}

