/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import javax.ejb.LocalHome;
import javax.naming.Context;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.stateless.StatelessHandleImpl;
import org.jboss.ejb3.stateless.StatelessLocalProxy;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessLocalProxyFactory
extends BaseStatelessProxyFactory {
    private static final Logger log = Logger.getLogger(StatelessLocalProxyFactory.class);

    public StatelessLocalProxyFactory(SessionContainer container, LocalBinding binding) {
        super(container, binding.jndiBinding());
    }

    @Override
    protected Class<?>[] getInterfaces() {
        EJBContainer statelessContainer = (EJBContainer)this.getContainer();
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        boolean bindTogether = false;
        if (localHome != null && this.bindHomeAndBusinessTogether(statelessContainer)) {
            bindTogether = true;
        }
        HashSet<Class> localInterfaces = new HashSet<Class>();
        localInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(this.getContainer())));
        this.ensureEjb21ViewComplete(localHome == null ? null : localHome.value(), ProxyFactoryHelper.getLocalInterfaces(this.getContainer()));
        if (localInterfaces.size() > 0) {
            localInterfaces.add(JBossProxy.class);
            if (bindTogether) {
                localInterfaces.add(localHome.value());
            }
        } else {
            log.warn((Object)"[EJBTHREE-933] NPE when deploying web service beans");
        }
        return localInterfaces.toArray(new Class[0]);
    }

    protected boolean bindHomeAndBusinessTogether(EJBContainer container) {
        return ProxyFactoryHelper.getLocalHomeJndiName(container).equals(this.jndiName);
    }

    @Override
    public void start() throws Exception {
        super.start();
        EJBContainer statelessContainer = (EJBContainer)this.getContainer();
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statelessContainer)) {
            Class[] interfaces = new Class[]{localHome.value()};
            Object homeProxy = Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), interfaces, (InvocationHandler)new StatelessLocalProxy(this.getContainer()));
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()), (Object)homeProxy);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        EJBContainer statelessContainer = (EJBContainer)this.getContainer();
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statelessContainer)) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()));
        }
    }

    @Override
    public Object createProxy() {
        return this.constructProxy(new StatelessLocalProxy(this.getContainer()));
    }

    @Override
    protected StatelessHandleImpl getHandle() {
        StatelessHandleImpl handle = new StatelessHandleImpl();
        LocalBinding remoteBinding = (LocalBinding)((Advisor)this.getContainer()).resolveAnnotation(LocalBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }
}

