/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import javax.naming.NameNotFoundException;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.spi.DeploymentEndpointResolver;
import org.jboss.deployment.spi.EndpointInfo;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.deployers.tmp.EjbModuleEjbResolver;
import org.jboss.ejb3.javaee.JavaEEComponentHelper;
import org.jboss.ejb3.javaee.JavaEEModule;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss5DeploymentScope
implements DeploymentScope {
    public static final String ATTACHMENT_KEY = "org.jboss.ejb3.deployers.JBoss5DeploymentScope.deployments";
    private static final Logger log = Logger.getLogger(JBoss5DeploymentScope.class);
    private ConcurrentHashMap<String, Ejb3Deployment> deployments;
    private DeploymentEndpointResolver endpointResolver;
    private EjbModuleEjbResolver ejbRefResolver;
    private String shortName;
    private String baseName;

    public JBoss5DeploymentScope(VFSDeploymentUnit parent, boolean isEar) {
        this.shortName = parent.getSimpleName();
        this.baseName = null;
        if (isEar) {
            this.baseName = this.shortName;
            int idx = this.shortName.lastIndexOf(46);
            if (idx > 0) {
                this.baseName = this.shortName.substring(0, idx);
            }
        }
        this.deployments = (ConcurrentHashMap)parent.getAttachment(ATTACHMENT_KEY);
        if (this.deployments == null) {
            this.deployments = new ConcurrentHashMap();
            parent.addAttachment(ATTACHMENT_KEY, this.deployments);
        }
        this.endpointResolver = (DeploymentEndpointResolver)parent.getAttachment(DeploymentEndpointResolver.class);
    }

    public JBoss5DeploymentScope(VFSDeploymentUnit parent, boolean isEar, String shortName) {
        this(parent, isEar);
        this.ejbRefResolver = new EjbModuleEjbResolver(this, shortName);
    }

    public void setDeployment(Ejb3Deployment deployment) {
        this.ejbRefResolver.setDeployment(deployment);
    }

    public DeploymentEndpointResolver getEndpointResolver() {
        return this.endpointResolver;
    }

    public void setEndpointResolver(DeploymentEndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }

    public Collection<Ejb3Deployment> getEjbDeployments() {
        return this.deployments.values();
    }

    public void register(Ejb3Deployment deployment) {
        String pathName = deployment.getDeploymentUnit().getRootFile().getPathName();
        if (pathName.startsWith(this.shortName)) {
            pathName = pathName.length() > this.shortName.length() ? pathName.substring(this.shortName.length() + 1) : "";
        }
        this.deployments.put(pathName, deployment);
    }

    public void unregister(Ejb3Deployment deployment) {
        String pathName = deployment.getDeploymentUnit().getRootFile().getPathName();
        if (pathName.startsWith(this.shortName)) {
            pathName = pathName.substring(this.shortName.length() + 1);
        }
        this.deployments.remove(pathName);
    }

    public Ejb3Deployment findRelativeDeployment(String relativeName) {
        if (relativeName.startsWith("../")) {
            relativeName = relativeName.substring(3);
        }
        return this.deployments.get(relativeName);
    }

    public EJBContainer getEjbContainer(Class businessIntf, String vfsContext) throws NameNotFoundException {
        if (this.ejbRefResolver != null) {
            return this.ejbRefResolver.getEjbContainer(businessIntf);
        }
        EJBContainer container = null;
        EndpointInfo endpoint = this.endpointResolver.getEndpointInfo(businessIntf, "ejb", vfsContext);
        if (endpoint != null) {
            ObjectName ejbON;
            log.debug((Object)("Found endpoint for interface: " + businessIntf + ", endpoint: " + endpoint));
            Ejb3Deployment deployment = this.deployments.get(endpoint.getPathName());
            String ejbObjectName = JavaEEComponentHelper.createObjectName((JavaEEModule)deployment, (String)endpoint.getName());
            try {
                ejbON = new ObjectName(ejbObjectName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to build ejb container ObjectName", e);
            }
            container = (EJBContainer)deployment.getContainer(ejbON);
        } else {
            log.debug((Object)("Failed to find endpoint for interface: " + businessIntf));
        }
        return container;
    }

    public EJBContainer getEjbContainer(String ejbLink, Class businessIntf, String vfsContext) {
        if (this.ejbRefResolver != null) {
            return this.ejbRefResolver.getEjbContainer(ejbLink, businessIntf);
        }
        EJBContainer container = null;
        EndpointInfo endpoint = this.endpointResolver.getEndpointInfo(ejbLink, "ejb", vfsContext);
        if (endpoint != null) {
            ObjectName ejbON;
            log.debug((Object)("Found endpoint for ejbLink: " + ejbLink + ", endpoint: " + endpoint));
            Ejb3Deployment deployment = this.deployments.get(endpoint.getPathName());
            String ejbObjectName = JavaEEComponentHelper.createObjectName((JavaEEModule)deployment, (String)endpoint.getName());
            try {
                ejbON = new ObjectName(ejbObjectName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to build ejb container ObjectName", e);
            }
            container = (EJBContainer)deployment.getContainer(ejbON);
        } else {
            log.debug((Object)("Failed to find endpoint for ejbLink: " + ejbLink));
            try {
                container = this.getEjbContainer(businessIntf, vfsContext);
            }
            catch (NameNotFoundException e) {
                log.debug((Object)("Did not resolve container by interface: " + businessIntf), (Throwable)e);
            }
        }
        return container;
    }

    public String getName() {
        return this.shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

