/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.management.ObjectName;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerServiceFacade
implements TimerService {
    private ObjectName objectName;
    private TimerService delegate;

    protected TimerServiceFacade(ObjectName objectName, TimerService delegate) {
        this.objectName = objectName;
        this.delegate = delegate;
    }

    private void assertAllowedIn(String timerMethod) {
        AllowedOperationsAssociation.assertAllowedIn((String)timerMethod, (int)(AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD));
    }

    public Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createSingleActionTimer");
        return this.delegate.createSingleActionTimer(expiration, timerConfig);
    }

    public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createSingleActionTimer");
        return this.delegate.createSingleActionTimer(duration, timerConfig);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createTimer");
        return this.delegate.createTimer(initialExpiration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createTimer");
        return this.delegate.createTimer(expiration, info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createTimer");
        return this.delegate.createTimer(initialDuration, intervalDuration, info);
    }

    public Timer createIntervalTimer(Date initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createIntervalTimer");
        return this.delegate.createIntervalTimer(initialDuration, intervalDuration, timerConfig);
    }

    public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createIntervalTimer");
        return this.delegate.createIntervalTimer(initialDuration, intervalDuration, timerConfig);
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createTimer");
        return this.delegate.createTimer(duration, info);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createCalendarTimer");
        return this.delegate.createCalendarTimer(schedule);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createCalendarTimer");
        return this.delegate.createCalendarTimer(schedule, timerConfig);
    }

    protected ObjectName getContainerId() {
        return this.objectName;
    }

    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.getTimers");
        return this.delegate.getTimers();
    }
}

