/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb3.client.JndiPropertyInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.injection.lang.reflect.BeanPropertyFactory;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientWebServiceRefHandler<X extends RemoteEnvironment>
implements InjectionHandler<X> {
    private static Logger logger = Logger.getLogger(ClientWebServiceRefHandler.class);
    private Map<String, ServiceReferenceMetaData> srefMap = new HashMap<String, ServiceReferenceMetaData>();

    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        throw new IllegalStateException("Annotations are not handled in the client");
    }

    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        throw new IllegalStateException("Annotations are not handled in the client");
    }

    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        throw new IllegalStateException("Annotations are not handled in the client");
    }

    public void loadXml(X xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        ServiceReferencesMetaData serviceRefs = xml.getServiceReferences();
        if (serviceRefs == null) {
            return;
        }
        for (ServiceReferenceMetaData sref : serviceRefs) {
            if (this.srefMap.get(sref.getServiceRefName()) != null) {
                throw new IllegalStateException("Duplicate <service-ref-name> in " + sref);
            }
            this.srefMap.put(sref.getServiceRefName(), sref);
            String encName = "env/" + sref.getServiceRefName();
            AnnotatedElement annotatedElement = sref.getAnnotatedElement();
            if (annotatedElement == null) {
                if (sref.getInjectionTargets() != null && sref.getInjectionTargets().size() > 0) {
                    for (ResourceInjectionTargetMetaData trg : sref.getInjectionTargets()) {
                        annotatedElement = InjectionUtil.findInjectionTarget((ClassLoader)container.getClassloader(), (ResourceInjectionTargetMetaData)trg);
                        this.addInjector(container, encName, annotatedElement);
                    }
                    continue;
                }
                logger.warn((Object)("No injection target for service-ref: " + sref.getServiceRefName()));
                continue;
            }
            if (annotatedElement instanceof Type) continue;
            this.addInjector(container, encName, annotatedElement);
        }
    }

    private void addInjector(InjectionContainer container, String encName, AnnotatedElement annotatedElement) {
        JndiPropertyInjector jndiInjector;
        if (annotatedElement instanceof Method) {
            BeanProperty prop = BeanPropertyFactory.create((AccessibleObject)((Method)annotatedElement));
            jndiInjector = new JndiPropertyInjector(prop, encName, container.getEnc());
        } else if (annotatedElement instanceof Field) {
            BeanProperty prop = BeanPropertyFactory.create((AccessibleObject)((Field)annotatedElement));
            jndiInjector = new JndiPropertyInjector(prop, encName, container.getEnc());
        } else {
            throw new IllegalStateException("Annotated element for '" + encName + "' is niether Method nor Field: " + annotatedElement);
        }
        container.getInjectors().add(jndiInjector);
    }
}

