/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.deployers.AbstractOptionalVFSRealDeployer;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientScanningDeployer
extends AbstractOptionalVFSRealDeployer<JBossClientMetaData> {
    public AppClientScanningDeployer() {
        super(JBossClientMetaData.class);
        this.setOutput(JBossClientMetaData.class);
    }

    @Override
    public void deploy(VFSDeploymentUnit unit, JBossClientMetaData dd) throws DeploymentException {
        if (dd != null) {
            return;
        }
        try {
            String mainClassName = this.getMainClassName(unit);
            if (mainClassName == null) {
                return;
            }
            Class<?> mainClass = unit.getClassLoader().loadClass(mainClassName);
            this.log.info((Object)("mainClass = " + mainClass));
            if (this.hasAnnotations(mainClass)) {
                dd = new JBossClientMetaData();
                unit.addAttachment(JBossClientMetaData.class, (Object)dd);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMainClassName(VFSDeploymentUnit unit) throws IOException {
        VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
        this.log.trace((Object)("parsing " + file));
        if (file == null) {
            return null;
        }
        try {
            String className;
            Manifest mf = VFSUtils.readManifest((VirtualFile)file);
            Attributes attrs = mf.getMainAttributes();
            String string = className = attrs.getValue(Attributes.Name.MAIN_CLASS);
            return string;
        }
        finally {
            file.close();
        }
    }

    private boolean hasAnnotations(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (cls.getAnnotations().length > 0) {
            return true;
        }
        for (Field f : cls.getDeclaredFields()) {
            if (f.getAnnotations().length <= 0) continue;
            return true;
        }
        return this.hasAnnotations(cls.getSuperclass());
    }
}

