/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.aspects.remoting.interceptors.invoker;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class InvokerInterceptor implements Interceptor
{

   public String getName()
   {
      return "InvokerInterceptor";
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      Object ret = null;

      // Will use the locator to determine which remoting interceptors to insert into chain
      // Returns a new invocation with the marshalling and transport interceptors added.
      Invocation newInvocation = RemotingInterceptorFactory.injectRemotingInterceptors(invocation);

      if (newInvocation != null)
      {
         ret = newInvocation.invokeNext();
      }
      else
      {
         throw new RuntimeException("Could not make invocation due to new invocation object being null.");
      }

      return ret;
   }
}