package org.jboss.mx.loading;

import java.net.URL;
import java.util.Set;

import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.classloading.spi.Translator;

public interface UnifiedLoaderRepositoryDCLMBean
{
   public DomainClassLoader newClassLoader(final URL url, boolean addToRepository)
   throws Exception;
   public DomainClassLoader newClassLoader(final URL url, final URL origURL, boolean addToRepository)
      throws Exception;
   
   public void removeClassLoader(DomainClassLoader cl);
   
   public LoaderRepositoryDomain registerClassLoader(DomainClassLoader ucl);
   
   public LoaderRepositoryDomain getInstance();
   
   public URL[] getURLs();
   
   // Aspect stuff
   public Translator getTranslator();
   public void setTranslator(Translator t);

   /** Called by LoadMgr to obtain all class loaders for the given className
    *@return LinkedList<UnifiedClassLoader3>, may be null
    */
   public Set getPackageClassLoaders(String className);

   /** A utility method that iterates over all repository class loader and
    * display the class information for every UCL that contains the given
    * className
    */
   public String displayClassInfo(String className);

   /** Get the number of classes loaded into the ULR cache.
    * @return the classes cache size.
    */
   public int getCacheSize();
   /** Get the number of UnifiedClassLoader3s (UCLs) in the ULR
    * @return the number of UCLs in the ULR
    */
   public int getClassLoadersSize();
   /** Flush the ULR classes cache
    */
   public void flush();
}
