/*
 * Decompiled with CFR 0.152.
 */
package test.performance.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;

public class SerializeTEST
extends TestCase {
    private Object obj;
    private String desc;

    public SerializeTEST(String s, Object obj, String desc) {
        super(s);
        this.obj = obj;
        this.desc = desc;
    }

    public void testIt() {
        System.out.println("\n" + this.desc);
        System.out.println("1000 Serializations, Repeat: x10");
        System.out.println("(this may take a while...)");
        long start = 0L;
        long end = 0L;
        float avg = 0.0f;
        boolean size = false;
        try {
            Object result = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 1000; ++invocationIterations) {
                    baos.reset();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(this.obj);
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    result = ois.readObject();
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.print("\nAverage: " + avg / 10.0f);
            System.out.println("   Size: " + baos.toByteArray().length);
        }
        catch (Exception e) {
            SerializeTEST.fail((String)e.toString());
        }
    }
}

