/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.mejb;

import java.rmi.RemoteException;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.mejb.ListenerRegistration;
import org.jboss.mx.util.MBeanServerLocator;

public class ManagementBean
implements SessionBean {
    private static Logger log = Logger.getLogger(ManagementBean.class);
    private SessionContext mContext;
    private MBeanServer mbeanServer;
    private ObjectName mManagementService;

    public Object getAttribute(ObjectName pName, String pAttribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException {
        try {
            if (this.mManagementService == null) {
                return this.mbeanServer.getAttribute(pName, pAttribute);
            }
            return this.mbeanServer.invoke(this.mManagementService, "getAttribute", new Object[]{pName, pAttribute}, new String[]{ObjectName.class.getName(), String.class.getName()});
        }
        catch (RuntimeOperationsException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                throw new AttributeNotFoundException("MBean attribute not found: " + pAttribute);
            }
            throw e;
        }
    }

    public AttributeList getAttributes(ObjectName pName, String[] pAttributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        if (this.mManagementService == null) {
            return this.mbeanServer.getAttributes(pName, pAttributes);
        }
        try {
            return (AttributeList)this.mbeanServer.invoke(this.mManagementService, "getAttributes", new Object[]{pName, pAttributes}, new String[]{ObjectName.class.getName(), String[].class.getName()});
        }
        catch (MBeanException me) {
            log.error((Object)"getAttributes() got exception from cluster service", (Throwable)me);
            return null;
        }
    }

    public String getDefaultDomain() throws RemoteException {
        if (this.mManagementService == null) {
            return J2EEDomain.getDomainName();
        }
        try {
            return (String)this.mbeanServer.getAttribute(this.mManagementService, "DefaultDomain");
        }
        catch (JMException jme) {
            log.error((Object)"getDefaultDomain() got exception from cluster service", (Throwable)jme);
            return null;
        }
    }

    public Integer getMBeanCount() throws RemoteException {
        if (this.mManagementService == null) {
            try {
                Set mbeans = this.queryNames(new ObjectName("*:*"), null);
                return new Integer(mbeans.size());
            }
            catch (Exception e) {
                return new Integer(0);
            }
        }
        try {
            return (Integer)this.mbeanServer.invoke(this.mManagementService, "getMBeanCount", new Object[0], new String[0]);
        }
        catch (JMException jme) {
            log.error((Object)"getMBeanCount() got exception from cluster service", (Throwable)jme);
            return null;
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName pName) throws IntrospectionException, InstanceNotFoundException, ReflectionException, RemoteException {
        if (this.mManagementService == null) {
            return this.mbeanServer.getMBeanInfo(pName);
        }
        try {
            return (MBeanInfo)this.mbeanServer.invoke(this.mManagementService, "getMBeanInfo", new Object[]{pName}, new String[]{ObjectName.class.getName()});
        }
        catch (MBeanException me) {
            log.error((Object)"getMBeanInfo() got exception from cluster service", (Throwable)me);
            return null;
        }
    }

    public javax.management.j2ee.ListenerRegistration getListenerRegistry() throws RemoteException {
        return new ListenerRegistration((ManagementHome)this.mContext.getEJBObject().getEJBHome(), new String[0]);
    }

    public Object invoke(ObjectName pName, String pOperationName, Object[] pParams, String[] pSignature) throws InstanceNotFoundException, MBeanException, ReflectionException, RemoteException {
        if (pOperationName.equals("start")) {
            pOperationName = "mejbStart";
        } else if (pOperationName.equals("startRecursive")) {
            pOperationName = "mejbStartRecursive";
        } else if (pOperationName.equals("stop")) {
            pOperationName = "mejbStop";
        }
        if (this.mManagementService == null) {
            return this.mbeanServer.invoke(pName, pOperationName, pParams, pSignature);
        }
        return this.mbeanServer.invoke(this.mManagementService, "invoke", new Object[]{pName, pOperationName, pParams, pSignature}, new String[]{ObjectName.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()});
    }

    public boolean isRegistered(ObjectName pName) throws RemoteException {
        if (this.mManagementService == null) {
            return this.mbeanServer.isRegistered(pName);
        }
        try {
            Boolean lCheck = (Boolean)this.mbeanServer.invoke(this.mManagementService, "isRegistered", new Object[]{pName}, new String[]{ObjectName.class.getName()});
            if (lCheck != null) {
                return lCheck;
            }
        }
        catch (JMException jme) {
            log.error((Object)"isRegistered() got exception from cluster service", (Throwable)jme);
        }
        return false;
    }

    public Set queryNames(ObjectName pName, QueryExp pQuery) throws RemoteException {
        if (this.mManagementService == null) {
            return this.mbeanServer.queryNames(pName, pQuery);
        }
        try {
            return (Set)this.mbeanServer.invoke(this.mManagementService, "queryNames", new Object[]{pName, pQuery}, new String[]{ObjectName.class.getName(), QueryExp.class.getName()});
        }
        catch (JMException jme) {
            log.error((Object)"queryNames() got exception from cluster service", (Throwable)jme);
            return null;
        }
    }

    public void setAttribute(ObjectName pName, Attribute pAttribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, RemoteException {
        if (this.mManagementService == null) {
            this.mbeanServer.setAttribute(pName, pAttribute);
        } else {
            this.mbeanServer.invoke(this.mManagementService, "setAttribute", new Object[]{pName, pAttribute}, new String[]{ObjectName.class.getName(), String.class.getName()});
        }
    }

    public AttributeList setAttributes(ObjectName pName, AttributeList pAttributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        if (this.mManagementService == null) {
            return this.mbeanServer.setAttributes(pName, pAttributes);
        }
        try {
            return (AttributeList)this.mbeanServer.invoke(this.mManagementService, "setAttributes", new Object[]{pName, pAttributes}, new String[]{ObjectName.class.getName(), AttributeList.class.getName()});
        }
        catch (MBeanException me) {
            log.error((Object)"setAttributes() got exception from cluster service", (Throwable)me);
            return null;
        }
    }

    public ObjectInstance createMBean(String pClass, ObjectName pName, Object[] pParameters, String[] pSignature) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, RemoteException {
        if (this.mManagementService == null) {
            return this.mbeanServer.createMBean(pClass, pName, pParameters, pSignature);
        }
        try {
            return (ObjectInstance)this.mbeanServer.invoke(this.mManagementService, "createMBean", new Object[]{pClass, pName, pParameters, pSignature}, new String[]{String.class.getName(), ObjectName.class.getName(), Object[].class.getName(), String[].class.getName()});
        }
        catch (InstanceNotFoundException infe) {
            log.error((Object)"createMBean() got exception from cluster service", (Throwable)infe);
            return null;
        }
    }

    public void unregisterMBean(ObjectName pName) throws InstanceNotFoundException, MBeanRegistrationException, RemoteException {
        if (this.mManagementService == null) {
            this.mbeanServer.unregisterMBean(pName);
        } else {
            try {
                this.mbeanServer.invoke(this.mManagementService, "unregisterMBean", new Object[]{pName}, new String[]{ObjectName.class.getName()});
            }
            catch (MBeanException me) {
                log.error((Object)"unregisterMBean() got exception from cluster service", (Throwable)me);
            }
            catch (ReflectionException re) {
                log.error((Object)"unregisterMBean() got exception from cluster service", (Throwable)re);
            }
        }
    }

    public void addNotificationListener(ObjectName pBroadcaster, ObjectName pListener, NotificationFilter pFilter, Object pHandback) throws InstanceNotFoundException, RemoteException {
        if (this.mManagementService == null) {
            this.mbeanServer.addNotificationListener(pBroadcaster, pListener, pFilter, pHandback);
        } else {
            try {
                this.mbeanServer.invoke(this.mManagementService, "addNotificationListener", new Object[]{pBroadcaster, pListener, pFilter, pHandback}, new String[]{ObjectName.class.getName(), ObjectName.class.getName(), NotificationFilter.class.getName(), Object.class.getName()});
            }
            catch (MBeanException me) {
                log.error((Object)"addNotificationListener() got exception from cluster service", (Throwable)me);
            }
            catch (ReflectionException re) {
                log.error((Object)"addNotificationListener() got exception from cluster service", (Throwable)re);
            }
        }
    }

    public void removeNotificationListener(ObjectName pBroadcaster, ObjectName pListener) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
        if (this.mManagementService == null) {
            this.mbeanServer.removeNotificationListener(pBroadcaster, pListener);
        } else {
            try {
                this.mbeanServer.invoke(this.mManagementService, "removeNotificationListener", new Object[]{pBroadcaster, pListener}, new String[]{ObjectName.class.getName(), ObjectName.class.getName()});
            }
            catch (MBeanException me) {
                log.error((Object)"removeNotificationListener() got exception from cluster service", (Throwable)me);
            }
            catch (ReflectionException re) {
                log.error((Object)"removeNotificationListener() got exception from cluster service", (Throwable)re);
            }
        }
    }

    public void ejbCreate() throws CreateException {
        block10: {
            if (this.mbeanServer == null) {
                try {
                    InitialContext jndiCtx = new InitialContext();
                    String serverName = (String)jndiCtx.lookup("java:comp/env/Server-Name");
                    serverName = serverName.trim();
                    if (serverName == null || serverName.length() == 0 || serverName.equals("null")) {
                        try {
                            this.mbeanServer = MBeanServerLocator.locateJBoss();
                            break block10;
                        }
                        catch (IllegalStateException e) {
                            throw new CreateException("No local JMX MBeanServer available");
                        }
                    }
                    Object lServer = jndiCtx.lookup(serverName);
                    if (lServer != null) {
                        if (lServer instanceof MBeanServer) {
                            this.mbeanServer = (MBeanServer)lServer;
                            break block10;
                        }
                        throw new CreateException("Server: " + lServer + " reference by Server-Name: " + serverName + " is not of type MBeanServer");
                    }
                    throw new CreateException("Server-Name " + serverName + " does not reference an Object in JNDI");
                }
                catch (NamingException ne) {
                    throw new EJBException((Exception)ne);
                }
            }
        }
        try {
            ObjectName haManagement = new ObjectName("jboss:service=HAManagement");
            ObjectInstance oi = this.mbeanServer.getObjectInstance(haManagement);
            this.mManagementService = oi.getObjectName();
        }
        catch (Exception e) {
            log.debug((Object)"ejbCreate() failed to locate jboss:service=HAManagement", (Throwable)e);
        }
    }

    public String toString() {
        return "Management [  ]";
    }

    public void setSessionContext(SessionContext aContext) throws EJBException {
        this.mContext = aContext;
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
    }

    public void ejbRemove() throws EJBException {
    }
}

