/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.destination;

import java.util.HashSet;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.CreateDestinationFactory;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;

public class JBossMessagingCreateDestinationFactory
implements CreateDestinationFactory {
    private static final Logger log = Logger.getLogger(JBossMessagingCreateDestinationFactory.class);
    private String serverPeerName;
    private String postOfficeName;

    public String getServerPeerName() {
        return this.serverPeerName;
    }

    public void setServerPeerName(String serverPeerName) {
        this.serverPeerName = serverPeerName;
    }

    public String getPostOfficeName() {
        return this.postOfficeName;
    }

    public void setPostOfficeName(String postOfficeName) {
        this.postOfficeName = postOfficeName;
    }

    public void create() {
        if (this.serverPeerName == null) {
            throw new IllegalStateException("serverPeerName has not been set");
        }
        if (this.postOfficeName == null) {
            throw new IllegalStateException("postOfficeName has not been set");
        }
    }

    public Object create(DeploymentUnit unit, JBossMessageDrivenBeanMetaData mdb) throws DeploymentException {
        ObjectName objectName;
        ActivationConfigPropertiesMetaData properties;
        String destinationJNDIName = null;
        String destinationType = null;
        ActivationConfigMetaData activationConfig = mdb.getActivationConfig();
        if (activationConfig != null && (properties = activationConfig.getActivationConfigProperties()) != null) {
            destinationJNDIName = JBossMessagingCreateDestinationFactory.getActivationConfigProperty(properties, "destination");
            destinationType = JBossMessagingCreateDestinationFactory.getActivationConfigProperty(properties, "destinationType");
        }
        if (destinationJNDIName == null || destinationJNDIName.trim().length() == 0) {
            log.warn((Object)("Unable to determine destination for " + mdb.getName()));
            return null;
        }
        boolean isTopic = false;
        if (destinationType == null) {
            log.warn((Object)("Unable to determine destination type for " + mdb.getName()));
            return null;
        }
        if (!destinationType.equals(Queue.class.getName())) {
            if (destinationType.equals(Topic.class.getName())) {
                isTopic = true;
            } else {
                log.warn((Object)("Unknown destination type '" + destinationType + "' for " + mdb.getName()));
                return null;
            }
        }
        ServiceMetaData result = new ServiceMetaData();
        result.setConstructor(new ServiceConstructorMetaData());
        String destinationName = this.createDestinationNameFromJNDIName(destinationJNDIName);
        if (isTopic) {
            objectName = ObjectNameFactory.create((String)("jboss.messaging.destination:service=Topic,name=" + destinationName));
            result.setCode("org.jboss.jms.server.destination.TopicService");
            result.setXMBeanDD("xmdesc/Topic-xmbean.xml");
        } else {
            objectName = ObjectNameFactory.create((String)("jboss.messaging.destination:service=Queue,name=" + destinationName));
            result.setCode("org.jboss.jms.server.destination.QueueService");
            result.setXMBeanDD("xmdesc/Queue-xmbean.xml");
        }
        result.setObjectName(objectName);
        ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
        attribute.setName("JNDIName");
        attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(destinationJNDIName));
        result.addAttribute(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("ServerPeer");
        attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(this.serverPeerName));
        result.addAttribute(attribute);
        ServiceDependencyMetaData dependency = new ServiceDependencyMetaData();
        dependency.setIDependOn(this.serverPeerName);
        result.addDependency(dependency);
        dependency = new ServiceDependencyMetaData();
        dependency.setIDependOn(this.postOfficeName);
        result.addDependency(dependency);
        HashSet<String> depends = mdb.getDepends();
        if (depends == null) {
            depends = new HashSet<String>();
            mdb.setDepends(depends);
        }
        depends.add(objectName.getCanonicalName());
        return result;
    }

    protected static String getActivationConfigProperty(ActivationConfigPropertiesMetaData properties, String name) {
        ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)properties.get(name);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    private String createDestinationNameFromJNDIName(String destinationJNDIName) {
        if (destinationJNDIName == null) {
            return null;
        }
        return destinationJNDIName.replace('/', '.');
    }
}

