/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.management;

import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;

/**
 * Abstract component dispatcher.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public abstract class AbstractRuntimeComponentDispatcher implements RuntimeComponentDispatcher
{
   private MetaValueFactory valueFactory;

   protected AbstractRuntimeComponentDispatcher(MetaValueFactory valueFactory)
   {
      if (valueFactory == null)
         valueFactory = MetaValueFactory.getInstance();
      this.valueFactory = valueFactory;
   }

   /**
    * Create meta value.
    *
    * @param value the value
    * @return meta value instance
    */
   protected MetaValue create(Object value)
   {
      return valueFactory.create(value);
   }

   /**
    * Unwrap meta value.
    *
    * @param metaValue the meta value
    * @return unwrapped value
    */
   protected Object unwrap(MetaValue metaValue)
   {
      return valueFactory.unwrap(metaValue);
   }

   /**
    * Get the arguments from meta values.
    *
    * @param param the meta value parameters
    * @return unwrapped object array
    */
   protected Object[] toArguments(MetaValue... param)
   {
      Object[] args = new Object[param.length];
      for(int i=0; i < param.length; i++)
      {
         args[i] = unwrap(param[i]);
      }
      return param;
   }

   /**
    * Get the parameters signatures.
    *
    * @param param the parameters
    * @return signatures
    */
   protected static String[] toSignature(MetaValue... param)
   {
      String[] signature = new String[param.length];
      for(int i=0; i < param.length; i++)
      {
         signature[i] = param[i].getMetaType().getTypeName();
      }
      return signature;
   }
}
