/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.management.builders;

import java.util.Map;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.plugins.advice.WrapperAdvice;
import org.w3c.dom.Document;

/**
 * A ManagedObjectBuilder for use as an override to the ConnectionFactoryDeployer
 * 
 * @author Scott.Stark@jboss.org
 * @author adrian@jboss.org
 * @version $Revision: 63726 $
 */
public class ConnectionFactoryDeployerManagedObjectBuilder
   implements ManagedObjectCreator
{
   private static Logger log = Logger.getLogger(ConnectionFactoryDeployerManagedObjectBuilder.class);

   public void build(DeploymentUnit unit, Map<String, ManagedObject> map) 
      throws DeploymentException
   {
      String name = unit.getSimpleName();
      if(name.endsWith("-ds.xml"))
      {
         Map<String, Object> attachments = unit.getTransientManagedObjects().getAttachments();
         log.debug(name+" attachments: "+attachments);
         String attachName = Document.class.getName();
         Document document = unit.getAttachment(attachName, Document.class);
         ManagedObject mo = new DomDataSourceManagedObject(attachName, document);
         ManagedObject wrapMO = WrapperAdvice.wrapManagedObject(mo);
         map.put(attachName, wrapMO);
      }
   }
}
