/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.management.builders;

import java.io.Serializable;

import org.jboss.logging.Logger;
import org.jboss.managed.api.Fields;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * This represents an element in a dom metadata model.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class DomFields extends DefaultFieldsImpl
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 1L;
   private static final Logger log = Logger.getLogger(DomFields.class);

   /** The parent datasources type element */
   private Element element;
   /** */
   private boolean deleteOnEmptyValue = true;
   
   /**
    * Create a new DOMFields.
    *
    * @param element the datasources/type element
    * @param elementName the name of the datasources/type
    *    child element this field corresponds to
    */
   public DomFields(Element element, String elementName)
   {
      this(element, elementName, true);
   }
   public DomFields(Element element, String elementName, boolean deleteOnEmptyValue)
   {
      this.element = element;
      this.setField(Fields.NAME, elementName);
      this.deleteOnEmptyValue = deleteOnEmptyValue;
   }

   public String getElementName()
   {
      return (String) super.getField(Fields.NAME);
   }
   public Serializable getField(String name)
   {
      if (VALUE.equals(name))
      {
         String elementName = getElementName();
         NodeList nodes = element.getElementsByTagName(elementName);
         if (nodes.getLength() == 0)
            return null;
         else
         {
            Element element = (Element) nodes.item(0);
            return element.getTextContent();
         }
      }
      return super.getField(name);
   }

   /**
    * Sets the VALUE value to the element text content. A null or empty
    * value removes the element.
    * TODO: need special handling of the datasource-type field as this
    * requires changing the name of the parent datasources/type element.
    */
   public void setField(String name, Serializable value)
   {
      if (VALUE.equals(name))
      {
         String string = value.toString();
         String elementName = getElementName();
         NodeList nodes = element.getElementsByTagName(elementName);
         Element childElement = null;
         if (nodes.getLength() == 0)
         {
            if (string == null || (deleteOnEmptyValue && string.length() == 0))
               return;
            Document doc = element.getOwnerDocument();
            childElement = doc.createElement(elementName);
            element.appendChild(childElement);
         }
         else
         {
            childElement = (Element) nodes.item(0);
            if (string == null || string.length() == 0)
            {
               element.removeChild(childElement);
               return;
            }
         }
         childElement.setTextContent(string);
         if( log.isTraceEnabled() )
         {
            Document document = element.getOwnerDocument();
            StringBuffer tmp = new StringBuffer("After update of ");
            tmp.append(elementName);
            tmp.append('[');
            tmp.append(DOMWriter.printNode(document, false));
            tmp.append(']');
            log.trace(tmp.toString());
         }
         return;
      }
      super.setField(name, value);
   }

}
