/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.management.builders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.managed.plugins.advice.WrapperAdvice;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;

/**
 * A ManagedObjectBuilder for use as an override to the FakeDataSourceDeployer
 * 
 * @author Scott.Stark@jboss.org
 * @author adrian@jboss.org
 * @version $Revision:$
 */
public class FakeConnectionFactoryDeployerManagedObjectBuilder
   implements ManagedObjectCreator
{
   private static Logger log = Logger.getLogger(ConnectionFactoryDeployerManagedObjectBuilder.class);
   /**
    * A mapping from the managed property name to the attachment property name.
    */
   private Map<String, String> propertyNameMappings = new HashMap<String, String>();

   public Map<String, String> getPropertyNameMappings()
   {
      return propertyNameMappings;
   }

   public void setPropertyNameMappings(Map<String, String> mangedToMBeanNames)
   {
      // Need to reverse the mapping
      for(String key : mangedToMBeanNames.keySet())
      {
         String value = mangedToMBeanNames.get(key);
         propertyNameMappings.put(value, key);
      }
   }

   public void build(DeploymentUnit unit, Map<String, ManagedObject> map) 
      throws DeploymentException
   {
      String name = unit.getSimpleName();
      if(name.endsWith("-dsf.xml"))
      {
         Map<String, Object> attachments = unit.getTransientManagedObjects().getAttachments();
         log.info(name+" attachments: "+attachments);
         ServiceDeployment service = unit.getAttachment(ServiceDeployment.class);
         if( service == null )
            throw new DeploymentException("Failed to find ServiceDeployment in "+unit.getName());
         List<ServiceMetaData> services = service.getServices();
         // TODO, can have multiple datasources in a deployment
         if( services.size() != 1 )
            throw new DeploymentException("Expected only 1 ServiceMetaData but saw "+services.size()+" in "+unit.getName());
         ServiceMetaData dsMetaData = services.get(0);
         String attachName = ServiceMetaData.class.getName();
         ManagedObject mo = new ServiceManagedObject(attachName, dsMetaData, propertyNameMappings);
         ManagedObject wrapMO = WrapperAdvice.wrapManagedObject(mo);
         map.put(attachName, wrapMO);
         // The datasource type...
         attachName = "FakeConnectionFactoryDeployer.datasource-type";
         ManagedObjectImpl typeMO = new ManagedObjectImpl(attachName);
         DefaultFieldsImpl f21 = new DefaultFieldsImpl();
         f21.setName("datasource-type");
         f21.setDescription("The type of the DataSource");
         f21.setMandatory(true);
         f21.setValue("local-tx-datasource");
         HashSet<MetaValue> values = new HashSet<MetaValue>();
         values.add(SimpleValueSupport.wrap("local-tx-datasource"));
         values.add(SimpleValueSupport.wrap("no-tx-datasource"));
         values.add(SimpleValueSupport.wrap("xa-datasource"));
         f21.setLegalValues(values);
         f21.setMetaType(SimpleMetaType.STRING);
         ManagedPropertyImpl dsType = new ManagedPropertyImpl(typeMO, f21);
         typeMO.getProperties().put("datasource-type", dsType);
         wrapMO = WrapperAdvice.wrapManagedObject(typeMO);
         map.put(attachName, wrapMO);
      }
   }
}
