/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.management.builders;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceMetaData;

/**
 * A ManagedObject implementation for ServiceMetaData attachments.
 * 
 * TODO: move to common location.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class ServiceManagedObject extends ManagedObjectImpl
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 1L;

   /**
    * ServiceManagedObject ctor
    */
   public ServiceManagedObject(String attachmentName, ServiceMetaData metaData)
   {
      this(attachmentName, metaData, null);
   }
   /**
    * Create a mapping for ServiceMetaData by creating a ServiceAttributeFields
    * instance for each entry in propertyNameMappings.
    * 
    * @param attachmentName - the ServiceMetaData attachment key
    * @param metaData - the ServiceMetaData attachment
    * @param propertyNameMappings - A mapping from the managed
    *    property name to the attachment property name.
    */
   public ServiceManagedObject(String attachmentName, ServiceMetaData metaData,
         Map<String, String> propertyNameMappings)
   {
      super(attachmentName);
      try
      {
         Collection<ManagedProperty> properties = getProperties().values();
         List<ServiceAttributeMetaData> attributes = metaData.getAttributes();
         for(ServiceAttributeMetaData attr : attributes)
         {
            String fieldName = attr.getName();
            String mappedName = null;
            if( propertyNameMappings != null )
               mappedName = propertyNameMappings.get(fieldName);
            ServiceAttributeFields attrFields = new ServiceAttributeFields(attr, fieldName, mappedName);
            // Should be coming from the metadata
            if( fieldName.equals("ConnectionProps") )
            {
               String[] itemNames = {"conn-prop1", "conn-prop2"};
               String[] itemDescriptions = {"conn-prop1 description", "conn-prop2 description"};
               MetaType[] itemTypes = {SimpleMetaType.STRING, SimpleMetaType.STRING};
               CompositeMetaType propsType = new ImmutableCompositeMetaType("java.lang.Properties", "DS connection properties",
                     itemNames, itemDescriptions, itemTypes);
               attrFields.setMetaType(propsType);
            }
            properties.add(new ManagedPropertyImpl(this, attrFields));            
         }
      }
      catch (RuntimeException e)
      {
         throw e;
      }
      catch (Exception e)
      {
         throw new RuntimeException("Error creating ServiceManagedObject", e);
      }
      
   }

   @Override
   public String toString()
   {
      StringBuilder tmp = new StringBuilder("ServiceManagedObject{");
      tmp.append(super.getProperties());
      tmp.append('}');
      return tmp.toString();
   }
   
}
