/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.mock.ds;

import java.util.List;
import java.util.Properties;

import javax.naming.InitialContext;

import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

/**
 * A fake DataSource connection object.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class FakeDataSourceConn
   implements FakeDataSourceConnMBean
{
   private static Logger log = Logger.getLogger(FakeDataSourceConn.class);
   private DataSourceDeployment ds;
   private MockDataSource dsConn;

   public FakeDataSourceConn(DataSourceDeployment ds)
   {
      this.ds = ds;
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getDepends()
    */
   public List<String> getDepends()
   {
      return ds.getDepends();
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getDriverClass()
    */
   public String getDriverClass()
   {
      return ds.getDriverClass();
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getJdbcURL()
    */
   public String getJdbcURL()
   {
      return ds.getJdbcURL();
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getJndiName()
    */
   public String getJndiName()
   {
      return ds.getJndiName();
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getMaxPoolSize()
    */
   public int getMaxPoolSize()
   {
      return Integer.parseInt(ds.getMaxPoolSize());
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getMinPoolSize()
    */
   public int getMinPoolSize()
   {
      return Integer.parseInt(ds.getMinPoolSize());
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getPassword()
    */
   public String getPassword()
   {
      return ds.getPassword();
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getSecurityDomain()
    */
   public String getSecurityDomain()
   {
      return ds.getSecurityDomain();
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getTypeMapping()
    */
   public String getTypeMapping()
   {
      return ds.getTypeMapping();
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#getUsername()
    */
   public String getUsername()
   {
      return ds.getUsername();
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setDriverClass(java.lang.String)
    */
   public void setDriverClass(String driverClass)
   {
      log.info("setDriverClass, "+driverClass);
      ds.setDriverClass(driverClass);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setJdbcURL(java.lang.String)
    */
   public void setJdbcURL(String jdbcURL)
   {
      log.info("setJdbcURL, "+jdbcURL);
      ds.setJdbcURL(jdbcURL);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setJndiName(java.lang.String)
    */
   public void setJndiName(String jndiName)
   {
      log.info("setJndiName, "+jndiName);
      ds.setJndiName(jndiName);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setMaxPoolSize(int)
    */
   public void setMaxPoolSize(int maxPoolSize)
   {
      ds.setMaxPoolSize(""+maxPoolSize);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setMinPoolSize(int)
    */
   public void setMinPoolSize(int minPoolSize)
   {
      ds.setMinPoolSize(""+minPoolSize);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setPassword(java.lang.String)
    */
   public void setPassword(String password)
   {
      ds.setPassword(password);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setSecurityDomain(java.lang.String)
    */
   public void setSecurityDomain(String securityDomain)
   {
      ds.setSecurityDomain(securityDomain);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setTypeMapping(java.lang.String)
    */
   public void setTypeMapping(String typeMapping)
   {
      ds.setTypeMapping(typeMapping);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#setUsername(java.lang.String)
    */
   public void setUsername(String username)
   {
      ds.setUsername(username);
   }

   public Properties getConnectionProperties()
   {
      return ds.getConnectionProperties();
   }
   public void setConnectionProperties(Properties props)
   {
      ds.setConnectionProperties(props);
   }

   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#start()
    */
   public void start()
      throws Exception
   {
      dsConn = new MockDataSource();
      InitialContext ctx = new InitialContext();
      Util.bind(ctx, ds.getJndiName(), dsConn);
      log.info("Bound MockDataSource under: "+ds.getJndiName());
   }
   /* (non-Javadoc)
    * @see org.jboss.profileservice.mock.ds.x#stop()
    */
   public void stop()
      throws Exception
   {
      InitialContext ctx = new InitialContext();
      Util.unbind(ctx, ds.getJndiName());
      log.info("Unbound MockDataSource under: "+ds.getJndiName());
   }
}
